package xmlUtil;

import xmlUtil.EchoXSAXHandler;

import daruma.wfs.SAXExceptionObserver;
import daruma.wfs.SOAPFaultDocumentBuilder;

import daruma.xml.UniversalName;
import daruma.xml.SimpleXPath;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.handler.XSAXDefaultHandler;

import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.Attributes;
import org.w3c.dom.Document;
import javax.xml.transform.TransformerException;
import javax.xml.parsers.ParserConfigurationException;

import java.io.OutputStream;

import java.util.Stack;


public class SimpleXPathXSAXHandler extends XSAXDefaultHandler
				    implements SAXExceptionObserver
{
	private	Stack<UniversalName>	path;
	private	Stack<UniversalName>	stack;
	private	String			encoding;

	public	SimpleXPathXSAXHandler( SimpleXPath  path ,
					OutputStream  out ,
					String  encoding ,
					XMLReader  parser ,
					boolean  isTopLevelHandler )
	{
		super( out , parser , isTopLevelHandler );

		this.encoding = encoding;

		this.path = new Stack<UniversalName>();
		for ( UniversalName  n  :  path.getList() )
		{
			this.path.push( n );
		}

		this.stack = new Stack<UniversalName>();
	}


	@Override
	public	void	xStartElement( String uri ,
				       String localName ,
				       String qName ,
				       Attributes  attrs ) throws SAXException
	{
		UniversalName	t = new UniversalName( uri , localName );

		this.stack.push( t );

		if ( this.stack.equals( this.path ) )
		{
			this.stack.pop();

			super.setContentHandlerDelegator
				( new EchoXSAXHandler
				  ( super.getOutputStream() ,
				    this.encoding ,
				    super.getParser() ,
				    false ,
				    this ) ,
				  uri , localName , qName , attrs );
		}
	}

	@Override
	public	void	xEndElement( String uri ,
				     String localName ,
				     String qName ) throws SAXException
	{
		this.stack.pop();
	}


	public	void	notifyError( SAXParseException  e ) throws SAXException
	{
		Document	doc;

		try
		{
			XMLFormatConverter
				.print( new SOAPFaultDocumentBuilder(e)
							      .newDocument() ,
					this.getOutputStream() );
		}
		catch( ParserConfigurationException  pe )
		{
			throw new SAXException( pe );
		}
		catch( TransformerException  te )
		{
			throw new SAXException( te );
		}

		throw e;
	}
}
