/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter;

import daruma.auth.Account;
import daruma.auth.AccountManager;
import daruma.auth.AuthenticationInfo;
import daruma.geometry.TransformationContext;
import daruma.global_switch.ImplementationSwitches;
import daruma.storage_manager.StorageAndAuth;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeName;
import daruma.wfs.filter.FilterParser;
import daruma.wfs.filter.PredicateDescription;
import daruma.xml.SAXExceptionObserver;
import daruma.xml.handler.XSAXDOMCreateHandler;
import daruma.xml.util.XMLParseErrorException;
import java.io.OutputStream;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class FilterHandler
extends XSAXDOMCreateHandler {
    private ElementName elementName;
    private TypeDefinition type;
    private TransformationContext trans;
    private StorageAndAuth storage;
    private SAXExceptionObserver errorReceiver;
    private PredicateDescription predicate;

    public FilterHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, ElementName elementName, TypeDefinition type, TransformationContext trans, StorageAndAuth storage, SAXExceptionObserver errorReceiver) {
        super(out, parser, isTopLevelHandler);
        this.elementName = elementName;
        this.type = type;
        this.trans = trans;
        this.storage = storage;
        this.errorReceiver = errorReceiver;
        this.predicate = null;
    }

    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.getCurrentNode() != null) {
            // empty if block
        }
        super.xStartElement(uri, localName, qName, attrs);
    }

    public void xCharacters(char[] str, int offset, int length) throws SAXException {
        super.xCharacters(str, offset, length);
    }

    public PredicateDescription getPredicate() {
        return this.predicate;
    }

    public String getSQLExpression() {
        if (this.predicate == null) {
            return null;
        }
        if (ImplementationSwitches.instance().getAuthUseEachFeaturePermission()) {
            AuthenticationInfo auth = this.storage.getAuth();
            String accountName = auth.getAuthenticatedAccount().getName();
            if (accountName == null) {
                return "FALSE";
            }
            AccountManager accountManager = this.storage.getAccountManager();
            Set<Account> s = accountManager.getAllowedAccountList(new Account(accountName));
            if (s.isEmpty()) {
                return "FALSE";
            }
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            buf.append(this.predicate.getSQLExpression());
            buf.append(") AND (");
            boolean first = true;
            for (Account a : s) {
                if (first) {
                    first = false;
                } else {
                    buf.append(" OR ");
                }
                buf.append("_account_");
                buf.append("='" + a.getName() + "'");
            }
            buf.append(")");
            return buf.toString();
        }
        return this.predicate.getSQLExpression();
    }

    public void xEndDocument() throws SAXException {
        Element filterElement = super.getDocumentElement();
        try {
            this.predicate = FilterParser.parseFilter(filterElement, new TypeName(this.elementName), this.type, this.trans, this.storage.getStorage(), this.getPrefixMap());
        }
        catch (XMLParseErrorException e) {
            SAXParseException se = new SAXParseException(e.getMessage(), super.getLocator(), e);
            se.setStackTrace(e.getStackTrace());
            this.errorReceiver.notifyError(se);
            throw se;
        }
    }

    public boolean detailedCheck(Node feature) throws XMLParseErrorException {
        return this.predicate.detailedCheck(feature);
    }
}

