/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs;

import daruma.geometry.TransformationContext;
import daruma.storage_manager.ElementInfo;
import daruma.storage_manager.StorageAndAuth;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.InstanceParseContext;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.wfs.TransactionResultInfo;
import daruma.wfs.filter.FilterHandler;
import daruma.xml.SAXExceptionObserver;
import daruma.xml.SimpleXPath;
import daruma.xml.URI;
import daruma.xml.UniversalName;
import daruma.xml.XMLTag;
import daruma.xml.handler.MispDefaultHandler;
import daruma.xml.handler.XSAXDOMCreateHandler;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.TextUtil;
import daruma.xml.util.XMLParseErrorException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TransactionUpdateHandler
extends MispDefaultHandler
implements SAXExceptionObserver {
    private StorageAndAuth storageAndAuth;
    private StorageManager storage;
    private InstanceParseContext parseContext;
    private SAXExceptionObserver errorReceiver;
    private TransactionResultInfo resultInfo;
    private ElementName specifiedElement;
    private TypeDefinition specifiedElementType;
    private ElementInfo specifiedElementInfo;
    private UpdateMode updateMode;
    private FilterHandler filter;
    private boolean filterTagFound;
    private List<PropertyHandler> properties;

    public TransactionUpdateHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, StorageAndAuth storage, InstanceParseContext parseContext, SAXExceptionObserver errorReceiver, TransactionResultInfo resultInfo) {
        super(out, parser, isTopLevelHandler);
        this.storageAndAuth = storage;
        this.storage = this.storageAndAuth.getStorage();
        this.parseContext = parseContext;
        this.errorReceiver = errorReceiver;
        this.specifiedElement = null;
        this.specifiedElementType = null;
        this.specifiedElementInfo = null;
        this.updateMode = UpdateMode.PRESERVE;
        this.filter = null;
        this.filterTagFound = false;
        this.resultInfo = resultInfo;
        if (this.resultInfo.countUpdate < 0L) {
            this.resultInfo.countUpdate = 0L;
        }
        this.properties = new ArrayList<PropertyHandler>();
    }

    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        assert (super.getCurrentLevel() == 1 || super.getCurrentLevel() == 2);
        XMLTag t = new XMLTag(uri, localName);
        SAXParseException mispNamespaceException = new SAXParseException(t.getLocalName() + " tag " + "should be in namespace " + URI.MISP, super.getLocator());
        if (super.getCurrentLevel() == 1) {
            String typeNameString;
            if (!t.getURI().equals(URI.MISP)) {
                this.throwError(mispNamespaceException);
                throw mispNamespaceException;
            }
            if (!t.getLocalName().equals("Update")) {
                this.throwError(new SAXParseException("unknown tag <" + t.getLocalName() + ">.", super.getLocator()));
            }
            if ((typeNameString = attrs.getValue("", "typeName")) == null) {
                this.throwError(new SAXParseException("typeName attribute not found in " + t.getLocalName() + " tag.", super.getLocator()));
            }
            try {
                this.specifiedElement = new ElementName(super.convertQNameStringToUniversalName(typeNameString));
            }
            catch (SAXException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator()));
            }
            TypeName elementTypeName = null;
            try {
                elementTypeName = this.storage.getElementTypeName(this.specifiedElement);
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator(), e));
            }
            if (elementTypeName == null) {
                this.throwError(new SAXParseException("element " + this.specifiedElement.getLocalName() + " in namespace " + this.specifiedElement.getNamespace() + " not registered", super.getLocator()));
            }
            try {
                this.specifiedElementType = this.storage.getTypeDefinition(elementTypeName);
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException("type of element " + this.specifiedElement.getLocalName() + " in namespace " + this.specifiedElement.getNamespace() + " not registered", super.getLocator()));
            }
            try {
                this.specifiedElementInfo = this.storage.getElementInfo(this.specifiedElement);
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException("Can't get information of element " + this.specifiedElement.getLocalName() + " in namespace " + this.specifiedElement.getNamespace() + ".", super.getLocator()));
            }
            String updateModeString = attrs.getValue("", "mode");
            if (updateModeString != null) {
                if (updateModeString.equals("preserve")) {
                    this.updateMode = UpdateMode.PRESERVE;
                } else if (updateModeString.equals("override")) {
                    this.updateMode = UpdateMode.OVERRIDE;
                } else if (updateModeString.equals("restore")) {
                    this.updateMode = UpdateMode.RESTORE;
                } else {
                    this.throwError(new SAXParseException("mode attribute of Update must be one of [preserve|override|restore]", super.getLocator()));
                }
            }
            return;
        }
        if (super.getCurrentLevel() == 2) {
            SAXParseException e;
            if (!t.getURI().equals(URI.MISP)) {
                this.throwError(mispNamespaceException);
                throw mispNamespaceException;
            }
            if (this.properties.size() == 0 && !t.getLocalName().equals("Property")) {
                e = new SAXParseException("unexpected tag \"" + t.getLocalName() + "\" found, " + "expected was Property tag.", super.getLocator());
                this.throwError(e);
            }
            if (t.getLocalName().equals("Property")) {
                if (this.filterTagFound) {
                    e = new SAXParseException("Property tag found after Filter tag", super.getLocator());
                    this.throwError(e);
                }
                PropertyHandler h = new PropertyHandler(super.getOutputStream(), super.getParser(), false, this, this.storage, this.parseContext, this.specifiedElementInfo, this.specifiedElement);
                this.properties.add(h);
                super.setContentHandlerDelegator(h, uri, localName, qName, attrs);
                return;
            }
            if (t.getLocalName().equals("Filter")) {
                if (this.filterTagFound) {
                    e = new SAXParseException("Filter multiply specified", super.getLocator());
                    this.throwError(e);
                }
                this.filterTagFound = true;
                this.filter = new FilterHandler(super.getOutputStream(), super.getParser(), false, this.specifiedElement, this.specifiedElementType, new TransformationContext(), this.storageAndAuth, this);
                super.setContentHandlerDelegator(this.filter, uri, localName, qName, attrs);
                return;
            }
            e = new SAXParseException("unexpected tag \"" + t.getLocalName() + "\" found, " + "expected was" + " Filter or Property tag.", super.getLocator());
            this.throwError(e);
        }
    }

    public void xEndDocument() throws SAXException {
        if (!this.filterTagFound) {
            this.throwError(new SAXParseException("Filter tag not found", super.getLocator()));
        }
        ArrayList<Pair<SimpleXPath, TypedInstance>> updateValues = new ArrayList<Pair<SimpleXPath, TypedInstance>>();
        HashSet<SimpleXPath> addedProperties = new HashSet<SimpleXPath>();
        for (PropertyHandler h : this.properties) {
            SimpleXPath property = h.getProperty();
            if (addedProperties.contains(property)) {
                this.throwError(new SAXParseException("Can't update: property \"" + property + "\" multiply specified", super.getLocator()));
            }
            addedProperties.add(property);
            updateValues.add(new Pair<SimpleXPath, TypedInstance>(h.getProperty(), h.getObj()));
        }
        try {
            int count = this.storage.updateElement(this.specifiedElement, updateValues, this.filter.getPredicate(), this.getTransactionSN(), true);
            this.resultInfo.countUpdate += (long)count;
        }
        catch (StorageException e) {
            this.throwError(new SAXParseException(e.getMessage(), super.getLocator()));
        }
    }

    public void notifyError(SAXParseException e) throws SAXException {
        this.errorReceiver.notifyError(e);
    }

    public void throwError(SAXParseException e) throws SAXException {
        this.notifyError(e);
        throw e;
    }

    private static class ValueHandler
    extends XSAXDOMCreateHandler
    implements SAXExceptionObserver {
        private SAXExceptionObserver errorReceiver;
        private StorageManager storage;
        private InstanceParseContext parseContext;
        private ElementInfo elementInfo;
        private ElementName topLevelElementName;
        private SimpleXPath path;
        private TypedInstance obj;

        public ValueHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, SAXExceptionObserver errorReceiver, StorageManager storage, InstanceParseContext parseContext, ElementInfo elementInfo, ElementName topLevelElementName, SimpleXPath path) {
            super(out, parser, isTopLevelHandler);
            this.errorReceiver = errorReceiver;
            this.storage = storage;
            this.parseContext = parseContext;
            this.elementInfo = elementInfo;
            this.topLevelElementName = topLevelElementName;
            this.path = path;
            this.obj = null;
        }

        public TypedInstance getObj() {
            return this.obj;
        }

        public void xEndDocument() throws SAXException {
            Element valueElement = super.getDocumentElement();
            UniversalName name = this.path.getList().isEmpty() ? this.topLevelElementName : this.path.getList().get(this.path.getList().size() - 1);
            Element element = ElementUtil.getNameReplacedElement(valueElement, name, super.getDOMDocument());
            LogWriter.qwrite("DEBUG", "data = [", valueElement, "]");
            LogWriter.qwrite("DEBUG", "replaced data = [", element, "]");
            LogWriter.qwrite("DEBUG", "path = [" + this.path + "]");
            try {
                TypeDefinition type = this.elementInfo.getTypeDefinition(this.path);
                LogWriter.qwrite("DEBUG", "type = [", type.getClass(), "]");
                SimpleXPath elementPath = this.path.getList().isEmpty() ? new SimpleXPath() : new SimpleXPath(this.path.getList().subList(0, this.path.getList().size() - 1));
                Pair<TypedInstance, Integer> r = type.createInstance(element, this.topLevelElementName, elementPath, this.storage, 0, this.parseContext);
                this.obj = r.getFirst();
                if (ElementUtil.hasExtraChildElements(element, r.getSecond())) {
                    List<Element> ex = ElementUtil.getExtraChildElements(element, r.getSecond());
                    for (Element e : ex) {
                        ElementUtil.debugPrint(e);
                    }
                    throw new TypeException("too many child elements of " + new ElementName(element).toString());
                }
            }
            catch (TypeException e) {
                this.throwError(new SAXParseException("invalid element " + this.topLevelElementName + ": " + e.getMessage(), super.getLocator()));
            }
            if (this.obj == null) {
                this.throwError(new SAXParseException("invalid element " + this.topLevelElementName.getLocalName() + " in namespace " + this.topLevelElementName.getNamespace(), super.getLocator()));
            }
        }

        public void notifyError(SAXParseException e) throws SAXException {
            this.errorReceiver.notifyError(e);
        }

        public void throwError(SAXParseException e) throws SAXException {
            this.errorReceiver.notifyError(e);
            throw e;
        }
    }

    private static class PropertyHandler
    extends MispDefaultHandler
    implements SAXExceptionObserver {
        private SAXExceptionObserver errorReceiver;
        private StorageManager storage;
        private InstanceParseContext parseContext;
        private ElementInfo elementInfo;
        private ElementName elementName;
        private StringBuilder propertyBuffer;
        private boolean readingProperty;
        private SimpleXPath property;
        private String value;
        private ValueHandler valueHandler;

        public PropertyHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, SAXExceptionObserver errorReceiver, StorageManager storage, InstanceParseContext parseContext, ElementInfo elementInfo, ElementName elementName) {
            super(out, parser, isTopLevelHandler);
            this.errorReceiver = errorReceiver;
            this.storage = storage;
            this.parseContext = parseContext;
            this.elementInfo = elementInfo;
            this.elementName = elementName;
            this.propertyBuffer = null;
            this.readingProperty = false;
            this.property = null;
            this.value = null;
            this.valueHandler = null;
        }

        public SimpleXPath getProperty() {
            return this.property;
        }

        public TypedInstance getObj() {
            return this.valueHandler.getObj();
        }

        public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            XMLTag t = new XMLTag(uri, localName);
            SAXParseException mispNamespaceException = new SAXParseException(t.getLocalName() + " tag " + "should be in namespace " + URI.MISP, super.getLocator());
            if (!t.getURI().equals(URI.MISP)) {
                this.throwError(mispNamespaceException);
                throw mispNamespaceException;
            }
            if (super.getCurrentLevel() == 1) {
                if (!t.getLocalName().equals("Property")) {
                    this.throwError(new SAXParseException("Property tag expected, but was t.getLocalName()", super.getLocator()));
                }
            } else if (super.getCurrentLevel() == 2) {
                if (t.getLocalName().equals("Name")) {
                    if (this.propertyBuffer != null) {
                        this.throwError(new SAXParseException("Name multiply defined", super.getLocator()));
                    }
                    this.propertyBuffer = new StringBuilder();
                    this.readingProperty = true;
                } else if (t.getLocalName().equals("Value")) {
                    this.valueHandler = new ValueHandler(super.getOutputStream(), super.getParser(), false, this, this.storage, this.parseContext, this.elementInfo, this.elementName, this.property);
                    super.setContentHandlerDelegator(this.valueHandler, uri, localName, qName, attrs);
                } else {
                    this.throwError(new SAXParseException("Unexpected tag: " + t.getLocalName(), super.getLocator()));
                }
            }
        }

        public void xEndElement(String uri, String localName, String qName) throws SAXException {
            XMLTag t = new XMLTag(uri, localName);
            if (t.getLocalName().equals("Name")) {
                this.readingProperty = false;
                try {
                    this.property = TextUtil.convertQNamePathToSimpleXPath(this.propertyBuffer.toString(), super.getPrefixMap());
                }
                catch (XMLParseErrorException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            }
        }

        public void xCharacters(char[] str, int offset, int length) throws SAXException {
            if (this.readingProperty) {
                this.propertyBuffer.append(str, offset, length);
            }
        }

        public void xEndDocument() throws SAXException {
            if (this.valueHandler == null) {
                this.throwError(new SAXParseException("Value tag not found", super.getLocator()));
            }
            if (this.propertyBuffer == null) {
                this.throwError(new SAXParseException("Property tag not found", super.getLocator()));
            }
        }

        public void notifyError(SAXParseException e) throws SAXException {
            this.errorReceiver.notifyError(e);
        }

        public void throwError(SAXParseException e) throws SAXException {
            this.notifyError(e);
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UpdateMode {
        PRESERVE,
        OVERRIDE,
        RESTORE;

    }
}

