/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.geometry.TransformationContext;
import daruma.sql.SQLDataType;
import daruma.sql.SQLDataTypeConstant;
import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.InstanceParseContext;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.util.XMLParseErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyXMLTypeDefinition
extends TypeDefinition {
    public AnyXMLTypeDefinition() {
        super(true, false);
    }

    @Override
    public SQLDataType getSingleSQLDataType() {
        return SQLDataTypeConstant.BLOB;
    }

    @Override
    public Pair<TypedInstance, Integer> createInstance(Element element, ElementName topLevelElement, SimpleXPath path, StorageManager storage, int elementIndex, InstanceParseContext parseContext) throws TypeException {
        String columnName;
        Element data;
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ": createInstance()");
        LogWriter.qwrite("DEBUG", "elementIndex = ", elementIndex);
        try {
            data = ElementUtil.getSingleChildElement(element);
        }
        catch (XMLParseErrorException e) {
            throw new TypeException(e);
        }
        LogWriter.qwrite("DEBUG", "in createInstance():", data);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            XMLFormatConverter.print(data, buf);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new TypeException("Can't convert XML to text", e);
        }
        if (path == null) {
            columnName = ColumnNameFactory.getTopLevelElementColumnName();
        } else {
            SimpleXPath newPath = new SimpleXPath(path);
            newPath.add(new UniversalName(element.getNamespaceURI(), element.getLocalName()));
            try {
                columnName = storage.getShortXPathStringForDB(newPath);
            }
            catch (StorageException e) {
                throw new TypeException(e);
            }
        }
        TableColumn column = new TableColumn(new TableColumnDefinition(columnName, this.getSingleSQLDataType()), buf.toString());
        ArrayList<TableColumn> columnList = new ArrayList<TableColumn>();
        columnList.add(column);
        return new Pair<TypedInstance, Integer>(new TypedInstance(columnList, this), elementIndex + 1);
    }

    @Override
    public int convertToXMLElement(Element element, Document doc, StorageManager storage, TransformationContext trans, List<TableColumn> columns, int index, long id) throws TypeException {
        if (index >= columns.size()) {
            throw new TypeException("internal error in " + this.getClass().getName() + ": unexpected instantiation");
        }
        String value = columns.get(index).getValue();
        ByteArrayInputStream buf = new ByteArrayInputStream(value.getBytes());
        try {
            XMLFormatConverter.readNode(buf, (Node)element);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new TypeException("Can't convert text to XML", e);
        }
        return index + 1;
    }
}

