/*
 * Decompiled with CFR 0.152.
 */
package daruma.global_switch;

import daruma.auth.PermissionType;
import daruma.util.FatalException;
import daruma.util.PropertyReader;

public class ImplementationSwitches {
    private static final String ENABLE_GEOMETRY_CONVERSION_PROPERTY = "daruma.geometry.enable_conversion";
    private static final boolean ENABLE_GEOMETRY_CONVERSION_DEFAULT = true;
    private boolean enableGeometryConversion = true;
    private static final String ALLOW_CONVERSION_TO_LOWER_DIMENSION_PROPERTY = "daruma.geometry.allow_conversion_to_lower_dimension";
    private static final String ALLOW_CONVERSION_TO_UPPER_DIMENSION_PROPERTY = "daruma.geometry.allow_conversion_to_upper_dimension";
    private static final boolean ALLOW_CONVERSION_TO_LOWER_DIMENSION_DEFAULT = true;
    private static final boolean ALLOW_CONVERSION_TO_UPPER_DIMENSION_DEFAULT = true;
    private boolean allowConversionToLowerDimension = true;
    private boolean allowConversionToUpperDimension = true;
    private static final String CREATE_GEOMETRY_INDEX_PROPERTY = "daruma.geometry.create_geometry_index";
    private static final boolean CREATE_GEOMETRY_INDEX_DEFAULT = false;
    private boolean createGeometryIndex = false;
    private String BACKEND_DB_TYPE_PROPERTY = "daruma.db.backend";
    private static final String BACKEND_DB_TYPE_DEFAULT = "MySQL";
    private BackendDBType backendDBType = BackendDBType.MySQL;
    private String MYSQL_HOST_PROPERTY = "daruma.mysql.host";
    private String MYSQL_PORT_PROPERTY = "daruma.mysql.port";
    private static final String MYSQL_HOST_DEFAULT = "localhost";
    private static final int MYSQL_PORT_DEFAULT = 3306;
    private static String mysqlHost = "localhost";
    private static int mysqlPort = 3306;
    private static final String AUTH_DEFAULT_RULE_PROPERTY = "daruma.auth.default_rule";
    private static final PermissionType AUTH_DEFAULT_RULE_DEFAULT;
    private static PermissionType authDefaultRule;
    private static final String AUTH_USE_EACH_FEATURE_PERMISSION_PROPERTY = "daruma.auth.use_each_feature_permission";
    private static final boolean AUTH_USE_EACH_FEATURE_PERMISSION_DEFAULT = false;
    private static boolean authUseEachFeaturePermission;
    private static final String NET_TIMEOUT_MSEC_PROPERTY = "daruma.net.timeout_msec";
    private static final int NET_TIMEOUT_MSEC_DEFAULT = 300000;
    private static int netTimeoutMSec;
    private static final String DO_FULL_GC_PROPERTY = "daruma.debug.do_full_gc";
    private static final boolean DO_FULL_GC_DEFAULT = false;
    private static boolean doFullGC;
    private static ImplementationSwitches obj;

    public ImplementationSwitches() throws FatalException {
        this.enableGeometryConversion = PropertyReader.getProperty(ENABLE_GEOMETRY_CONVERSION_PROPERTY, true);
        this.allowConversionToLowerDimension = PropertyReader.getProperty(ALLOW_CONVERSION_TO_LOWER_DIMENSION_PROPERTY, true);
        this.allowConversionToUpperDimension = PropertyReader.getProperty(ALLOW_CONVERSION_TO_UPPER_DIMENSION_PROPERTY, true);
        this.createGeometryIndex = PropertyReader.getProperty(CREATE_GEOMETRY_INDEX_PROPERTY, false);
        String backendDBTypeString = PropertyReader.getProperty(this.BACKEND_DB_TYPE_PROPERTY, BACKEND_DB_TYPE_DEFAULT);
        if (backendDBTypeString.equals("PostGIS")) {
            this.backendDBType = BackendDBType.PostGIS;
        } else if (backendDBTypeString.equals(BACKEND_DB_TYPE_DEFAULT)) {
            this.backendDBType = BackendDBType.MySQL;
        } else {
            throw new FatalException("invalid property value of [" + this.BACKEND_DB_TYPE_PROPERTY + "]," + " value = [" + (Object)((Object)this.backendDBType) + "]," + " expected was [PostGIS] or [MySQL].");
        }
        mysqlHost = PropertyReader.getProperty(this.MYSQL_HOST_PROPERTY, MYSQL_HOST_DEFAULT);
        mysqlPort = PropertyReader.getProperty(this.MYSQL_PORT_PROPERTY, 3306);
        String defaultRuleString = PropertyReader.getProperty(AUTH_DEFAULT_RULE_PROPERTY);
        if (defaultRuleString == null) {
            authDefaultRule = AUTH_DEFAULT_RULE_DEFAULT;
        } else if (defaultRuleString.equals("allow")) {
            authDefaultRule = PermissionType.Allow;
        } else if (defaultRuleString.equals("deny")) {
            authDefaultRule = PermissionType.Deny;
        } else {
            throw new FatalException("invalid property value of [daruma.auth.default_rule], value = [" + defaultRuleString + "]," + " expected was [allow] or [deny].");
        }
        authUseEachFeaturePermission = PropertyReader.getProperty(AUTH_USE_EACH_FEATURE_PERMISSION_PROPERTY, false);
        netTimeoutMSec = PropertyReader.getProperty(NET_TIMEOUT_MSEC_PROPERTY, 300000);
        doFullGC = PropertyReader.getProperty(DO_FULL_GC_PROPERTY, false);
    }

    public boolean getEnableGeometryConversion() {
        return this.enableGeometryConversion;
    }

    public boolean getAllowConversionToLowerDimension() {
        return this.allowConversionToLowerDimension;
    }

    public boolean getAllowConversionToUpperDimension() {
        return this.allowConversionToUpperDimension;
    }

    public boolean getCreateGeometryIndex() {
        return this.createGeometryIndex;
    }

    public BackendDBType getBackendDBType() {
        return this.backendDBType;
    }

    public boolean isPostGISBackend() {
        return this.backendDBType == BackendDBType.PostGIS;
    }

    public boolean isMySQLBackend() {
        return this.backendDBType == BackendDBType.MySQL;
    }

    public String getMySQLHost() {
        return mysqlHost;
    }

    public int getMySQLPort() {
        return mysqlPort;
    }

    public PermissionType getAuthDefaultRule() {
        return authDefaultRule;
    }

    public boolean getAuthUseEachFeaturePermission() {
        return authUseEachFeaturePermission;
    }

    public int getNetTimeoutMSec() {
        return netTimeoutMSec;
    }

    public boolean getDoFullGC() {
        return doFullGC;
    }

    public static void createInstance() throws FatalException {
        if (obj == null) {
            obj = new ImplementationSwitches();
        }
    }

    public static ImplementationSwitches instance() {
        return obj;
    }

    static {
        authDefaultRule = AUTH_DEFAULT_RULE_DEFAULT = PermissionType.Deny;
        authUseEachFeaturePermission = false;
        netTimeoutMSec = 300000;
        doFullGC = false;
        obj = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackendDBType {
        PostGIS,
        MySQL;

    }
}

