/*
 * Decompiled with CFR 0.152.
 */
package daruma.auth;

import daruma.auth.Account;
import daruma.util.LogWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountManager {
    private Map<Account, Set<Account>> accountMap = new HashMap<Account, Set<Account>>();
    private Map<Account, Set<Account>> reverseMap = new HashMap<Account, Set<Account>>();

    public void addAccount(Account account) {
        Set<Account> s = this.accountMap.get(account);
        if (s == null) {
            HashSet<Account> newSet = new HashSet<Account>();
            newSet.add(account);
            this.accountMap.put(account, newSet);
            HashSet<Account> newReverseSet = new HashSet<Account>();
            newReverseSet.add(account);
            this.reverseMap.put(account, newReverseSet);
        }
    }

    public void addAccount(Account account, Account member) {
        Set<Account> newSet;
        Set<Account> s = this.accountMap.get(account);
        if (s == null) {
            newSet = new HashSet<Account>();
            newSet.add(account);
        } else {
            newSet = s;
        }
        newSet.add(member);
        this.accountMap.put(account, newSet);
        HashSet<Account> newReverseSet = new HashSet<Account>();
        Set<Account> rs = this.accountMap.get(member);
        if (rs == null) {
            newReverseSet = new HashSet();
            newReverseSet.add(member);
        }
        newReverseSet.add(account);
        this.reverseMap.put(member, newReverseSet);
    }

    public Set<Account> getAllowedAccountList(Account account) {
        Set<Account> s = this.reverseMap.get(account);
        if (s == null) {
            return new HashSet<Account>();
        }
        return s;
    }

    public void debugPrint() {
        LogWriter.qwrite("DEBUG", "AccountManager: " + this.accountMap.size() + " accounts" + (this.accountMap.size() == 1 ? "" : "s"));
        for (Map.Entry<Account, Set<Account>> e : this.accountMap.entrySet()) {
            LogWriter.qwrite("DEBUG", "account: [", e.getKey().getName(), "]");
            for (Account a : e.getValue()) {
                LogWriter.qwrite("DEBUG", "  member account: [", a.getName(), "]");
            }
        }
    }
}

