/*
 * Decompiled with CFR 0.152.
 */
package mispClient.commands;

import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.SimpleXPath;
import daruma.xml.URI;
import daruma.xml.UniversalName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import mispClient.MispCommand;
import mispClient.MispCommandException;
import mispClient.commands.GetFeatureMispCommand;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import xmlUtil.SimpleXPathXSAXHandler;
import xmlUtil.XMLUtil;

public class GetFeatureDataOnlyMispCommand
extends MispCommand {
    private static final String GET_FEATURE_RESPONSE_ELEMENT_NAME = "GetFeatureResponse";
    private static final String FEATURE_COLLECTION_ELEMENT_NAME = "FeatureCollection";
    private static final String FEATURE_MEMBER_ELEMENT_NAME = "featureMember";
    private final ElementName featureName;
    private String filter;
    private OutputStream out;
    private String encoding;

    public GetFeatureDataOnlyMispCommand(ElementName featureName, String filter, OutputStream out, String encoding) {
        this.featureName = featureName;
        this.filter = filter;
        this.out = out;
        this.encoding = encoding;
    }

    public InputStream getInputStream() throws MispCommandException {
        return new GetFeatureMispCommand(this.featureName, this.filter, this.out).getInputStream();
    }

    public void processResponse(InputStream in) throws MispCommandException {
        SimpleXPath path = new SimpleXPath();
        path.add(new UniversalName(URI.MISP, GET_FEATURE_RESPONSE_ELEMENT_NAME));
        path.add(new UniversalName(URI.MISP, FEATURE_COLLECTION_ELEMENT_NAME));
        path.add(new UniversalName(URI.GML, FEATURE_MEMBER_ELEMENT_NAME));
        path.add((UniversalName)this.featureName);
        try {
            XMLReader parser = XMLUtil.createSAXParser();
            SimpleXPathXSAXHandler handler = new SimpleXPathXSAXHandler(path, this.out, this.encoding, parser, false);
            XMLUtil.handleXMLInputStream(handler, parser, in);
        }
        catch (SAXException e) {
            throw new MispCommandException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MispCommandException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MispCommandException(e.getMessage(), e);
        }
    }
}

