package daruma.xml.util;

import daruma.xml.URI;

import org.w3c.dom.Node;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;


public class NodeUtil
{
	private	NodeUtil()
	{
	}


	/* !!! [06/08/18 23:19 I.Noda] !!! 
	 * ʲNameSpace.findPredefinedPrefixIn ǤϤᤫ
	 */

	public	static	String	lookupNamespaceURI( Node  node ,
						    String  prefix )
	{
		if ( node.getPrefix() != null
		  && node.getPrefix().equals( prefix ) )
		{
			return( node.getNamespaceURI() );
		}


		NamedNodeMap	attributes = node.getAttributes();

		if ( attributes == null )
		{
			return( null );
		}

		for ( int  i = 0  ;  i < attributes.getLength()  ;  i ++ )
		{
			Attr	attr = (Attr)attributes.item(i);
			String	pref = attr.getPrefix();

			if ( prefix == null )
			{
				if ( pref == null
				  && attr.getLocalName().equals( "xmlns" ) )
				{
					return( attr.getValue() );
				}
			}
			else
			{
				if ( pref != null
				  && pref.equals( "xmlns" )
				  && prefix.equals( attr.getLocalName() ) )
				{
					return( attr.getValue() );
				}
			}
		}


		Node	parentNode = node.getParentNode();

		if ( parentNode != null )
		{
			return( NodeUtil.lookupNamespaceURI
				( parentNode , prefix ) );
		}
		else
		{
			return( null );
		}
	}
}
