#ifndef	   CODE_CONV_H_INCLUDED
#define	   CODE_CONV_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar 20 2006
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar 20 2006    base version.
//
//

#include  <xercesc/util/XMLString.hpp>
#include  <string>
#include  <iosfwd>

class  Local_Encoded_String
{
private:
	char *	str;

public:
	Local_Encoded_String( const XMLCh * const x )
		: str( xercesc::XMLString::transcode( x ) )
	{
	}

	~Local_Encoded_String()
	{
		xercesc::XMLString::release( &str );
	}

	bool is_null() const
	{
		return ! str;
	}

	operator std::string() const
	{
		if ( is_null() )
		{
			return( "" );
		}

		return( this -> str );
	}
};

class  XML_Parser_Encoded_String
{
private:
	XMLCh * str;

public:
	XML_Parser_Encoded_String( const char * const x )
		: str( xercesc::XMLString::transcode( x ) )
	{
	}

	~XML_Parser_Encoded_String()
	{
		xercesc::XMLString::release( &str );
	}

	operator const XMLCh *() const
	{
		return( this -> str );
	}
};

extern	std::ostream &  operator<< ( std::ostream &  ostrm ,
				     const Local_Encoded_String &  str );

#endif	/* CODE_CONV_H_INCLUDED */
