#include  "input_line_buffer.h"
#include  "test_environment.h"
#include  "compat_stringstream.h"


int    main( void )
{
	Test_Environment	t;


	{
		compat_stringstream	input( "" );

		Input_Line_Buffer	buf( input );

		t.Assert_Equals( false , buf.line_completed() );
	}


	{
		compat_stringstream	input( "abcdefg\nhijklmn\nopqrstu" );
		Input_Line_Buffer	buf( input );

		std::string	line;


		t.Assert_Equals_Critical( true , buf.line_completed() );
		buf.get_line( &line );
		t.Assert_Equals( "abcdefg" , line );

		t.Assert_Equals_Critical( true , buf.line_completed() );
		buf.get_line( &line );
		t.Assert_Equals( "hijklmn" , line );

		t.Assert_Equals_Critical( true , buf.line_completed() );
		buf.get_line( &line );
		t.Assert_Equals( "opqrstu" , line );
	}


	return( t.exit_status() );
}
