#ifndef	   MKDIR_MUTEX_H_INCLUDED
#define	   MKDIR_MUTEX_H_INCLUDED

// Author:		H. Shimora
// Created:		Nov 28 2005
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Nov 28 2005    base version.
//
//

#include  "path.h"
#include  "adjust_sleep.h"

// for mkdir(), rmdir()
#include  <unistd.h>
#include  <sys/types.h>
#include  <sys/stat.h>

// for errno
#include  <errno.h>

// for perror()
#include  <cstdio>


class  Mkdir_Mutex
{
public:
	static	const unsigned long	DEFAULT_POLLING_PERIOD_USEC
							    = 1000 * 1000;

private:
	const Path	dir_path;
	unsigned long	polling_period_usec;

public:
	Mkdir_Mutex( const Path &  dir_path ,
		     unsigned long  polling_period_usec
				     = DEFAULT_POLLING_PERIOD_USEC )
		: dir_path( dir_path ) ,
		  polling_period_usec( polling_period_usec )
	{
	}

	virtual	~Mkdir_Mutex()
	{
	}

	// attempt lock with blocking
	bool	lock()
	{
		while( ! this -> trylock() )
		{
			Adjust_Sleep::usleep( this -> polling_period_usec );
		}

		return( true );
	}

	// attempt lock without blocking
	bool	trylock()
	{
		if ( ::mkdir( this -> dir_path.native_string().c_str() ,
			      0777 ) == -1 )
		{
			if ( errno != EEXIST )
			{
				std::perror( "mkdir" );
			}

			return( false );
		}

		return( true );
	}

	// release lock
	bool	unlock()
	{
		if ( ::rmdir( this -> dir_path.native_string().c_str() )
		     == -1 )
		{
			std::perror( "rmdir" );

			return( false );
		}

		return( true );
	}
};


#endif	/* MKDIR_MUTEX_H_INCLUDED */
