#include  "debugstream.h"
#include  "asynchronousbuf.h"
#include  "fdstream.h"
#include  <iostream>
#include  <cstdio>
#include  <cstdarg>

using namespace std;

namespace Debug_Stream {

// external
#if 0
debugstream	dbg( STDOUT_FILENO , true );
#else
debugstream	dbg( STDOUT_FILENO , false );
#endif

debugstream::debugstream( int  fd ,  bool  async )
	: std::ostream( static_cast<std::streambuf *>(0) ) ,
	  buf( static_cast<std::streambuf *>(0) ) ,
	  need_delete_buf( true )
{
	this -> std::ios::init( &null_buffer );

	if ( async )
	{
		this -> buf = new asynchronousbuf( fd );
	}
	else
	{
		this -> buf = new fdstreambuf( fd );
	}
}

debugstream::debugstream( std::ostream &  ostrm )
	: std::ostream( static_cast<std::streambuf *>(0) ) ,
	  buf( ostrm.rdbuf() ) , need_delete_buf( false )
{
	this -> std::ios::init( &null_buffer );
}

debugstream::~debugstream()
{
	if ( this -> need_delete_buf )
	{
		delete buf;
	}
}

void   debugstream::inhibit( bool  flag )
{
	if ( flag )
	{
		this -> rdbuf( &null_buffer );
	}
	else
	{
		this -> rdbuf( buf );
	}
}

int    debugstream::printf( const char *  format , ... )
{
	this -> std::ostream::flush();

	if ( this -> rdbuf() != &null_buffer )
	{
		va_list	ap;
		va_start( ap , format );

		int	ret;
		ret = vprintf( static_cast<const char *>( format ) , ap );
		fflush( stdout );

		va_end( ap );

		return( ret );
	}

	return( 0 );
}

} // end of namespace Debug_Stream
