#include  "d2_triangle.h"

D2_Triangle::D2_Triangle( const D2_Vector &  p0 ,
			  const D2_Vector &  p1 ,
			  const D2_Vector &  p2 )
	: p0( p0 ) , p1( p1 ) , p2( p2 )
{
}

D2_Triangle::D2_Triangle( const D2_Segment &  p01 ,
			  const D2_Vector &  p2 )
	: p0( p01.point_0() ) , p1( p01.point_1() ) , p2( p2 )
{
}

FLOAT  D2_Triangle::signed_area() const
{
	return( this -> signed_area_2() / FLOAT(2.0) );
}

FLOAT  D2_Triangle::signed_area_2() const
{
	return(   (p0.x() - p2.x()) * (p1.y() - p2.y())
		+ (p1.x() - p2.x()) * (p2.y() - p0.y()) );
}

FLOAT  D2_Triangle::area() const
{
	return( float_traits<FLOAT>::fabs( this -> signed_area() ) );
}

FLOAT  D2_Triangle::area_2() const
{
	return( float_traits<FLOAT>::fabs( this -> signed_area_2() ) );
}

#include  "d2_polygon.h"
#include  <vector>

bool   D2_Triangle::intersect( const D2_Vector & p ,
			       bool  allow_on_segment ) const
{
	// XXX: use fast algorithm

	std::vector<D2_Vector>	vertex;
	vertex.push_back( p0 );
	vertex.push_back( p1 );
	vertex.push_back( p2 );

	return( D2_Polygon( vertex ).intersect( p , allow_on_segment ) );
}
