#include  "d2_triangle.h"
#include  "test_environment.h"

int    main( void )
{
	Test_Environment	t;


	{
		const D2_Vector	p1( 0.0 , 0.0 );
		const D2_Vector	p2( 3.0 , 0.0 );
		const D2_Vector	p3( 3.0 , 4.0 );

		const D2_Triangle	t1( p1 , p2 , p3 );
		const D2_Triangle	t2( p3 , p2 , p1 );

		{
			t.Assert_Nearly_Equals( +  6.0 , t1.signed_area() );
			t.Assert_Nearly_Equals( + 12.0 , t1.signed_area_2() );
			t.Assert_Nearly_Equals( +  6.0 , t1.area() );
			t.Assert_Nearly_Equals( + 12.0 , t1.area_2() );

			t.Assert_Nearly_Equals( -  6.0 , t2.signed_area() );
			t.Assert_Nearly_Equals( - 12.0 , t2.signed_area_2() );
			t.Assert_Nearly_Equals(    6.0 , t2.area() );
			t.Assert_Nearly_Equals(   12.0 , t2.area_2() );
		}
	}


	{
		const D2_Vector	p1( -100 , 200 );
		const D2_Vector	p2(  600 , 200 );
		const D2_Vector	p3(    0 , 200 );

		const D2_Triangle	tri( p1 , p2 , p3 );

		{
			t.Assert_Nearly_Equals( 0.0 , tri.signed_area_2() );
		}
	}


	{
		const D2_Vector	p1( -100 , 200 );

		const D2_Triangle	tri( p1 , p1 , p1 );

		{
			t.Assert_Nearly_Equals( 0.0 , tri.signed_area_2() );
		}
	}


	return( t.exit_status() );
}
