#include  "d2_composite_region.h"
#include  "d2_universal_region.h"
#include  "ref_count_ptr.h"

D2_Composite_Region::D2_Composite_Region( Type  t ,  const D2_Region &  d )
	: type( t ) , regions()
{
	regions.push_back( d );
}

D2_Composite_Region::D2_Composite_Region( Type  t ,
					  const D2_Region &  d1 ,
					  const D2_Region &  d2 )
	: type( t ) , regions()
{
	regions.push_back( d1 );
	regions.push_back( d2 );
}

D2_Composite_Region::~D2_Composite_Region()
{
#ifdef LIB_MEMORY
	regions.clear();
#endif
}

D2_Region  D2_Composite_Region::operator & ( const D2_Region&  region ) const
{
	ref_count_ptr<const D2_Region_Entity>	p;

	p = new D2_Composite_Region( D2_Composite_Region::And ,
				     this -> copy() , region );
	return( p );
}

D2_Region  D2_Composite_Region::operator | ( const D2_Region&  region ) const
{
	ref_count_ptr<const D2_Region_Entity>	p;

	p = new D2_Composite_Region( D2_Composite_Region::Or ,
				     this -> copy() , region );
	return( p );
}

D2_Region  D2_Composite_Region::operator ! () const
{
	ref_count_ptr<const D2_Region_Entity>	p;

	p = new D2_Composite_Region( D2_Composite_Region::Not ,
				     this -> copy() );
	return( p );
}

bool   D2_Composite_Region::in_region( const D2_Vector &  vec ) const
{
	// XXX : not tested.

	switch( type )
	{
	case And:
		if ( regions.empty() )
		{
			return( false );
		}

		for ( size_t  i = 0  ;  regions.size()  ;  i ++ )
		{
			if ( regions[i].in_region( vec ) == false )
			{
				return( false );
			}
		}

		return( true );

	case Or:
		for ( size_t  i = 0  ;  regions.size()  ;  i ++ )
		{
			if ( regions[i].in_region( vec ) == true )
			{
				return( true );
			}
		}

		return( false );

	case Not:
		if ( regions.size() == 1 )
		{
			return( ! regions[0].in_region( vec ) );
		}
		else
		{
			return( false );
		}

	default:
		return( false );
	}
}

ref_count_ptr<const D2_Region_Entity>  D2_Composite_Region::copy() const
{
	return( ref_count_ptr<const D2_Region_Entity>
		( new D2_Composite_Region( *this ) ) );
}
