#ifndef	   COMSTREAM_H_INCLUDED
#define	   COMSTREAM_H_INCLUDED

#if ! defined( TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE )

#include  <iostream>
#include  <string>
#include  <vector>
#include  <csignal>
#include  <cstdarg>

#include  "commandbuf.h"

class  comstream : public std::iostream
{
public:
	enum { BAD_PROCESSS_ID = commandbuf::BAD_PROCESSS_ID };
	enum { BAD_FD          = commandbuf::BAD_FD };

protected:
	commandbuf	buf;

public:
	comstream( const char * const * const  argv )
		: std::iostream( &buf ) , buf( argv ) {}

	comstream( const char *  file ,
		   const char * const * const  argv )
		: std::iostream( &buf ) , buf( file , argv ) {}

	comstream( const std::vector<std::string> &  argv,
		   const char * redirect_input_file
				  = static_cast<const char *>(0),
		   const char * redirect_output_file
				  = static_cast<const char *>(0) )
		: std::iostream( &buf ) ,
		  buf( argv , redirect_input_file, redirect_output_file ) {}

	comstream( const std::string &  file ,
		   const std::vector<std::string> &  argv,
		   const char * redirect_input_file
				  = static_cast<const char *>(0),
		   const char * redirect_output_file
				  = static_cast<const char *>(0) )
		: std::iostream( &buf ) ,
		  buf( file, argv ,
		       redirect_input_file, redirect_output_file ) {}

	comstream( const char *  argv0 ,  ... );

	comstream( int  (*func)(void) )
		: std::iostream( &buf ) , buf( func ) {}

	~comstream()			{ buf.close(); buf.wait(); }

	void	close( int  in_out = std::ios::in | std::ios::out )
					{ buf.close( in_out ); }
	pid_t	getpid()		{ return( buf.getpid() ); }
	int	kill( int  sig = SIGTERM )
					{ return( buf.kill( sig ) ); }
	int	fd( int  in_out ) const	{ return( buf.fd( in_out ) ); }
	int	poll() const		{ return( buf.poll() ); }
	void	wait()			{ return( buf.wait() ); }
	int	exit_status() const	{ return( buf.exit_status() ); }
};


class  icomstream : public std::istream
{
public:
	enum { BAD_PROCESSS_ID = commandbuf::BAD_PROCESSS_ID };
	enum { BAD_FD	  = commandbuf::BAD_FD };

protected:
	commandbuf	buf;

public:
	icomstream( const char * const * const  argv ,
		    const char * redirect_input_file
				  = static_cast<const char *>(0) )
		: std::istream( &buf ) ,
		  buf( argv ,
		       redirect_input_file ,
		       static_cast<const char *>(0) )
					{ buf.close( std::ios::in ); }

	icomstream( const char *  file ,
		    const char * const * const  argv ,
		    const char * redirect_input_file
				  = static_cast<const char *>(0) )
		: std::istream( &buf ) ,
		  buf( file , argv,
		       redirect_input_file ,
		       static_cast<const char *>(0) )
					{ buf.close( std::ios::in ); }

	icomstream( const std::vector<std::string> &  argv ,
		    const char * redirect_input_file
				  = static_cast<const char *>(0) )
		: std::istream( &buf ) ,
		  buf( argv ,
		       redirect_input_file ,
		       static_cast<const char *>(0) )
					{ buf.close( std::ios::in ); }

	icomstream( const std::string &  file ,
		    const std::vector<std::string> &  argv ,
		    const char * redirect_input_file
				  = static_cast<const char *>(0) )
		: std::istream( &buf ) ,
		  buf( file , argv ,
		       redirect_input_file ,
		       static_cast<const char *>(0) )
					{ buf.close( std::ios::in ); }

	icomstream( const char * argv0 , ... );

	icomstream( int  (*func)(void) ,
		    const char * redirect_input_file
				  = static_cast<const char *>(0) )
		: std::istream( &buf ) ,
		  buf( func,
		       redirect_input_file ,
		       static_cast<const char *>(0) ) {}

	~icomstream()			{ buf.close(); buf.wait(); }

	void	close( int  in_out = std::ios::in | std::ios::out )
					{ buf.close( in_out ); }
	pid_t	getpid()		{ return( buf.getpid() ); }
	int	kill( int  sig = SIGTERM )
					{ return( buf.kill( sig ) ); }
	int	fd( int  in_out ) const	{ return( buf.fd( in_out ) ); }
	int	poll() const		{ return( buf.poll() ); }
	void	wait()			{ return( buf.wait() ); }
	int	exit_status() const	{ return( buf.exit_status() ); }
};


class  ocomstream : public std::ostream
{
public:
	enum { BAD_PROCESSS_ID = commandbuf::BAD_PROCESSS_ID };
	enum { BAD_FD	       = commandbuf::BAD_FD };

protected:
	commandbuf	buf;

public:
	ocomstream( const char * const * const  argv ,
		    const char * redirect_output_file
				  = static_cast<const char *>(0) )
		: std::ostream( &buf ) ,
		  buf( argv,
		       static_cast<const char *>(0), redirect_output_file )
					{ buf.close( std::ios::out ); }

	ocomstream( const char *  file ,
		    const char * const * const  argv ,
		    const char * redirect_output_file
				  = static_cast<const char *>(0) )
		 : std::ostream( &buf ) ,
		   buf( file , argv ,
			static_cast<const char *>(0), redirect_output_file )
					{ buf.close( std::ios::out ); }

	ocomstream( const std::vector<std::string> &  argv ,
		    const char * redirect_output_file
				  = static_cast<const char *>(0) )
		: std::ostream( &buf ) ,
		  buf( argv ,
		       static_cast<const char *>(0), redirect_output_file )
					{ buf.close( std::ios::out ); }

	ocomstream( const std::string &  file ,
		    const std::vector<std::string> &  argv ,
		    const char * redirect_output_file
				  = static_cast<const char *>(0) )
		: std::ostream( &buf ) ,
		  buf( file , argv ,
		       static_cast<const char *>(0), redirect_output_file )
					{ buf.close( std::ios::out ); }

	ocomstream( int  (*func)(void) ,
		    const char * redirect_output_file
				  = static_cast<const char *>(0) )
		: std::ostream( &buf ) ,
		  buf( func ,
		       static_cast<const char *>(0), redirect_output_file ) {}

	ocomstream( const char * argv0 , ... );

	~ocomstream()			{ buf.close(); buf.wait(); }

	void	close( int  in_out = std::ios::in | std::ios::out )
					{ buf.close( in_out ); }
	pid_t	getpid()		{ return( buf.getpid() ); }
	int	kill( int  sig = SIGTERM )
						{ return( buf.kill( sig ) ); }
	int	fd( int  in_out ) const	{ return( buf.fd( in_out ) ); }
	void	wait()			{ return( buf.wait() ); }
	int	exit_status() const	{ return( buf.exit_status() ); }
};


inline
comstream::comstream( const char *  argv0 , ... )
	: std::iostream( &buf ) , buf()
{
	std::vector<std::string>	argv;
	argv.push_back( argv0 );

	va_list	ap;
	va_start( ap , argv0 );

	for(;;)
	{
		const char *	p = va_arg( ap , const char * );

		if ( ! p )
		{
			break;
		}

		argv.push_back( p );
	}

	va_end( ap );

	buf.invoke( std::string(argv[0]) , argv );
}

inline
icomstream::icomstream( const char *  argv0 , ... )
	: std::istream( &buf ) , buf()
{
	std::vector<std::string>	argv;
	argv.push_back( argv0 );

	va_list	ap;
	va_start( ap , argv0 );

	for(;;)
	{
		const char *	p = va_arg( ap , const char * );

		if ( ! p )
		{
			break;
		}

		argv.push_back( p );
	}

	va_end( ap );

	buf.invoke( std::string(argv[0]) , argv );
	buf.close( std::ios::in );
}

inline
ocomstream::ocomstream( const char *  argv0 , ... )
	: std::ostream( &buf ) , buf()
{
	std::vector<std::string>	argv;
	argv.push_back( argv0 );

	va_list	ap;
	va_start( ap , argv0 );

	for(;;)
	{
		const char *	p = va_arg( ap , const char * );

		if ( ! p )
		{
			break;
		}

		argv.push_back( p );
	}

	va_end( ap );

	buf.invoke( std::string(argv[0]) , argv );
	buf.close( std::ios::out );
}

#endif // ! defined( TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE )

#endif	/* COMSTREAM_H_INCLUDED */
