#ifndef	   PATH_CONVERTER_H_INCLUDED
#define	   PATH_CONVERTER_H_INCLUDED

// Author:		H. Shimora
// Created:		Jun  2 2009
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jun  2 2009    base version.
//
//

#include <string>
#include <cctype>

class Path_Converter
{
public:
    static std::string escape_slash( const std::string & path )
    {
        std::string ret;

        for ( size_t i = 0; i < path.length(); ++ i )
        {
            const char ch = path[i];

            switch( ch )
            {
            case '%':
                ret += "%25";
                break;

            case '/':
                ret += "%2f";
                break;

            default:
                ret += ch;
                break;
            }
        }

        return ret;
    }

    static std::string unescape_slash( const std::string & path )
    {
        std::string ret;

        for ( size_t i = 0; i < path.length(); ++ i )
        {
            const char ch = path[i];

            switch( ch )
            {
            case '%':
                if ( i + 2 < path.length() )
                {
                    unsigned char raw_ch = 0;

                    if ( std::isdigit( path[i+1] ) )
                    {
                        raw_ch += (path[i+1] - '0');
                    }
                    else
                    {
                        raw_ch += (path[i+1] - 'a');
                    }

                    raw_ch *= 16;

                    if ( std::isdigit( path[i+2] ) )
                    {
                        raw_ch += (path[i+2] - '0');
                    }
                    else
                    {
                        raw_ch += (path[i+2] - 'a' + 10);
                    }

                    ret += raw_ch;
                    i += 2;
                }
                break;

            default:
                ret += ch;
                break;
            }
        }

        return ret;
    }
};

#endif	/* PATH_CONVERTER_H_INCLUDED */
