#ifndef	   MMAP_IFSTREAMBUF_H_INCLUDED
#define	   MMAP_IFSTREAMBUF_H_INCLUDED

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  "streambuf_extension.h"
#include  "mmap_file.h"
#include  <string>


class  mmap_ifstreambuf : public streambuf_extension
{
private:
	 // not allowed.
	 mmap_ifstreambuf( const mmap_ifstreambuf & );

	 // not allowed.
	 mmap_ifstreambuf &  operator= ( const mmap_ifstreambuf & );

private:
	MMap_File	file;

public:
	mmap_ifstreambuf( const std::string &  path )
		: file( path , O_RDONLY )
	{
		if ( ! file.valid() )
		{
			return;
		}

		if ( ! file.attach_whole_file()
		  || ! file.valid() )
		{
			return;
		}

		this -> std::streambuf::setg
			( const_cast<char *>( this -> file.memory() ) ,
			  const_cast<char *>( this -> file.memory() ) ,
			  const_cast<char *>( this -> file.memory()
					      + this -> file.mapped_size() ) );
	}

	bool	valid() const
	{
		return( this -> file.valid() );
	}
};


#endif	/* MMAP_IFSTREAMBUF_H_INCLUDED */
