#ifndef	   FILE_POLLING_SEMAPHORE_H_INCLUDED
#define	   FILE_POLLING_SEMAPHORE_H_INCLUDED

// Author:		H. Shimora
// Created:		Nov 29 2005
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Nov 29 2005    base version.
//
//

#include  <fcntl.h>     // for creat()
#include  <unistd.h>	// for close()
#include  <sys/types.h>
#include  <sys/stat.h>  // for lstat()
#include  <errno.h>     // for errno
#include  <cstdio>      // for perror()

#include  "path.h"
#include  "adjust_sleep.h"

class  File_Polling_Semaphore
{
public:
	static	const unsigned long	DEFAULT_POLLING_PERIOD_USEC
							    = 1000 * 1000;

private:
	const Path	dir_path;
	unsigned long	polling_period_usec;

public:
	File_Polling_Semaphore( const Path &  dir_path ,
				unsigned long  polling_period_usec
						= DEFAULT_POLLING_PERIOD_USEC )
		: dir_path( dir_path ) ,
		  polling_period_usec( polling_period_usec )
	{
	}

	virtual	~File_Polling_Semaphore()
	{
	}

	bool	getvalue()
	{
		struct	stat	lstat_buf ;

		if ( ::lstat( this -> dir_path.native_string().c_str() ,
			      &lstat_buf ) == -1 )
		{
			if ( errno != ENOENT )
			{
				std::perror( "lstat" );
			}

			return( false );
		}

		return( true );
	}

	bool	wait()
	{
		while( ! this -> getvalue() )
		{
			Adjust_Sleep::usleep( this -> polling_period_usec );
		}

		return( true );
	}

	bool	post()
	{
		int	fd;
		if ( (fd = ::creat( this -> dir_path.native_string().c_str() ,
				    0666 )) == -1 )
		{
			if ( errno != EEXIST )
			{
				std::perror( "creat" );
			}

			return( false );
		}

		if ( ::close( fd ) == -1 )
		{
			std::perror( "close" );

			return( false );
		}

		return( true );
	}

	bool	remove()
	{
		if ( ::unlink( this -> dir_path.native_string().c_str() )
		     == -1 )
		{
			std::perror( "unlink" );

			return( false );
		}

		return( true );
	}
};


#endif	/* FILE_POLLING_SEMAPHORE_H_INCLUDED */
