#ifndef	   FDSTREAM_H_INCLUDED
#define	   FDSTREAM_H_INCLUDED

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  <iostream>
#include  "fdstreambuf.h"

class  fdstream : public std::iostream
{
protected:
	fdstreambuf	buf;

public:
	fdstream( int  fd ,  bool  auto_close = false )
		: std::iostream( static_cast<std::streambuf *>(0) ) ,
		  buf( fd ,  auto_close )
	{
		this -> std::ios::init( &buf );
	}

	void	close()
	{
		buf.close();
	}

	int	fd() const
	{
		return( buf.fd() );
	}
};


class  ifdstream : public std::istream
{
protected:
	fdstreambuf	buf;

public:
	ifdstream( int  fd ,  bool  auto_close = false )
		: std::istream( static_cast<std::streambuf *>(0) ) ,
		  buf( fd , auto_close )
	{
		this -> std::ios::init( &buf );
	}

	void	close()
	{
		buf.close();
	}

	int	fd() const
	{
		return( buf.fd() );
	}
};


class  ofdstream : public std::ostream
{
protected:
	fdstreambuf	buf;

public:
	ofdstream( int  fd ,  bool  auto_close = false )
		: std::ostream( static_cast<std::streambuf *>(0) ) ,
		  buf( fd , auto_close )
	{
		this -> std::ios::init( &buf );
	}

	void	close()
	{
		buf.close();
	}

	int	fd() const
	{
		return( buf.fd() );
	}
};


#endif	/* FDSTREAM_H_INCLUDED */
