#ifndef	   D2_RECTANGLE_REGION_H_INCLUDED
#define	   D2_RECTANGLE_REGION_H_INCLUDED

// Author:		H. Shimora
// Created:		Jun 16 2004
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jun 16 2004    base version.
//
//

#include  <cfloat>
#include  <vector>
#include  "d2_vector.h"
#include  "float_traits.h"


class  D2_Rectangle_Region
{
private:
	FLOAT	min_x_;
	FLOAT	max_x_;
	FLOAT	min_y_;
	FLOAT	max_y_;

public:
	D2_Rectangle_Region()
		: min_x_( + float_traits<FLOAT>::max() ) ,
		  max_x_( - float_traits<FLOAT>::max() ) ,
		  min_y_( + float_traits<FLOAT>::max() ) ,
		  max_y_( - float_traits<FLOAT>::max() )
	{
	}

	D2_Rectangle_Region( const D2_Rectangle_Region &  r )
		: min_x_( r.min_x() ) ,
		  max_x_( r.max_x() ) ,
		  min_y_( r.min_y() ) ,
		  max_y_( r.max_y() )
	{
	}

	D2_Rectangle_Region( FLOAT  min_x ,  FLOAT  max_x ,
			     FLOAT  min_y ,  FLOAT  max_y )
		: min_x_( min_x ) , max_x_( max_x ) ,
		  min_y_( min_y ) , max_y_( max_y )
	{
	}

	void	clear()
	{
		this -> set( + float_traits<FLOAT>::max() ,
			     - float_traits<FLOAT>::max() ,
			     + float_traits<FLOAT>::max() ,
			     - float_traits<FLOAT>::max() );
	}

	void	set( FLOAT  min_x , FLOAT  max_x ,
		     FLOAT  min_y , FLOAT  max_y )
	{
		this -> min_x_ = min_x;
		this -> max_x_ = max_x;
		this -> min_y_ = min_y;
		this -> max_y_ = max_y;
	}

	bool	valid() const
	{
		return( min_x_ <= max_x_ && min_y_ <= max_y_ );
	}

	FLOAT	min_x() const
	{
		return( min_x_ );
	}

	FLOAT	max_x() const
	{
		return( max_x_ );
	}

	FLOAT	min_y() const
	{
		return( min_y_ );
	}

	FLOAT	max_y() const
	{
		return( max_y_ );
	}

	FLOAT	center_x() const
	{
		return( (min_x_ + max_x_) / FLOAT(2.0) );
	}

	FLOAT	center_y() const
	{
		return( (min_y_ + max_y_) / FLOAT(2.0) );
	}

	FLOAT	width_x() const
	{
		if ( max_x_ < min_x_ )
		{
			return( 0.0 );
		}

		return( max_x_ - min_x_ );
	}

	FLOAT	width_y() const
	{
		if ( max_y_ < min_y_ )
		{
			return( 0.0 );
		}

		return( max_y_ - min_y_ );
	}

	FLOAT	area() const
	{
		if ( ! this -> valid() )
		{
			return( 0.0 );
		}
		else
		{
			return( (max_x_ - min_x_) * (max_y_ - min_y_) );
		}
	}


	void	extend_region( const D2_Vector &  v )
	{
		if ( v.x() < this -> min_x_ )
		{
			this -> min_x_ = v.x();
		}

		if ( v.x() > this -> max_x_ )
		{
			this -> max_x_ = v.x();
		}

		if ( v.y() < this -> min_y_ )
		{
			this -> min_y_ = v.y();
		}

		if ( v.y() > this -> max_y_ )
		{
			this -> max_y_ = v.y();
		}
	}

	void	extend_region( const std::vector<D2_Vector> &  v )
	{
		for( size_t  i = 0  ;  i < v.size()  ;  i ++ )
		{
			this -> extend_region( v[i] );
		}
	}

	void	extend_region( const D2_Rectangle_Region &  r )
	{
		if ( r.min_x() < this -> min_x_ )
		{
			this -> min_x_ = r.min_x();
		}

		if ( r.max_x() > this -> max_x_ )
		{
			this -> max_x_ = r.max_x();
		}

		if ( r.min_y() < this -> min_y_ )
		{
			this -> min_y_ = r.min_y();
		}

		if ( r.max_y() > this -> max_y_ )
		{
			this -> max_y_ = r.max_y();
		}
	}

	D2_Rectangle_Region	get_extend_region( const D2_Vector &  v )
	{
		D2_Rectangle_Region	r;

		r.extend_region( v );

		return( r );
	}

	bool	share_region( const D2_Rectangle_Region &  r ) const
	{
		return( (   this -> min_x() <= r.max_x()
			 && this -> max_x() >= r.min_x()
			 && this -> min_y() <= r.max_y()
			 && this -> max_y() >= r.min_y()) );
	}

	bool	include_region( const D2_Rectangle_Region &  r ) const
	{
		return( (   this -> min_x() <= r.min_x()
			 && this -> max_x() >= r.max_x()
			 && this -> min_y() <= r.min_y()
			 && this -> max_y() >= r.max_y()) );
	}

	bool	in_region( const D2_Vector &  v ) const
	{
		return( (   this -> min_x() <= v.x()
			 && this -> max_x() >= v.x()
			 && this -> min_y() <= v.y()
			 && this -> max_y() >= v.y()) );
	}

	D2_Rectangle_Region  get_surrounded_rectangle( FLOAT  buffer ) const
	{
		if ( ! this -> valid() )
		{
			return( *this );
		}

		return( D2_Rectangle_Region( this -> min_x() - buffer ,
					     this -> max_x() + buffer ,
					     this -> min_y() - buffer ,
					     this -> max_y() + buffer ) );
	}

	D2_Rectangle_Region  get_shrinked_rectangle( FLOAT  buffer ) const
	{
		if ( ! this -> valid() )
		{
			return( *this );
		}

		return( D2_Rectangle_Region
			( std::min( this -> min_x() + buffer ,
				    this -> max_x() ) ,
			  std::max( this -> max_x() - buffer ,
				    this -> min_x() ) ,
			  std::min( this -> min_y() + buffer ,
				    this -> max_y() ) ,
			  std::max( this -> max_y() - buffer ,
				    this -> min_y() ) ) );
	}


private:
	enum{ LEFT_SIDE = 0x01 , RIGHT_SIDE = 0x02 ,
	      DOWN_SIDE = 0x04 , UP_SIDE    = 0x08 };

	int	get_point_relation( FLOAT  x ,  FLOAT  y ) const
	{
		int	flags = 0x0;

		if ( x < this -> min_x() )
		{
			flags |= LEFT_SIDE;
		}
		else if ( x > this -> max_x() )
		{
			flags |= RIGHT_SIDE;
		}

		if ( y < this -> min_y() )
		{
			flags |= DOWN_SIDE;
		}
		else if ( y > this -> max_y() )
		{
			flags |= UP_SIDE;
		}

		return( flags );
	}


public:
	bool	clip_segment( D2_Vector *  p1 ,
			      D2_Vector *  p2 ,
			      const D2_Vector &  p1_org ,
			      const D2_Vector &  p2_org ) const
	{
		if ( ! this -> valid() )
		{
			return( false );
		}


		FLOAT	p1_x = p1_org.x();
		FLOAT	p1_y = p1_org.y();
		FLOAT	p2_x = p2_org.x();
		FLOAT	p2_y = p2_org.y();

		int	r1 = get_point_relation( p1_x , p1_y );
		int	r2 = get_point_relation( p2_x , p2_y );


		while( r1 || r2 )
		{
			if ( r1 & r2 )
			{
				break;
			}

			int	r = (r1 ? r1 : r2);

			FLOAT	tmp_x = static_cast<FLOAT>( 0.0 );
			FLOAT	tmp_y = static_cast<FLOAT>( 0.0 );

			if ( r & LEFT_SIDE )
			{
				tmp_y = p1_y
					+ (p2_y - p1_y)
					  * (this -> min_x() - p1_x)
					  / (p2_x - p1_x);

				tmp_x = this -> min_x();
			}
			else if ( r & RIGHT_SIDE )
			{
				tmp_y = p1_y
					+ (p2_y - p1_y)
					  * (this -> max_x() - p1_x)
					  / (p2_x - p1_x);

				tmp_x = this -> max_x();
			}
			else if ( r & DOWN_SIDE )
			{
				tmp_x = p1_x
					+ (p2_x - p1_x)
					  * (this -> min_y() - p1_y)
					  / (p2_y - p1_y);

				tmp_y = this -> min_y();
			}
			else if ( r & UP_SIDE )
			{
				tmp_x = p1_x
					+ (p2_x - p1_x)
					  * (this -> max_y() - p1_y)
					  / (p2_y - p1_y);

				tmp_y = this -> max_y();
			}

			if ( r == r1 )
			{
				p1_x = tmp_x;
				p1_y = tmp_y;
				r1 = get_point_relation( p1_x , p1_y );
			}
			else
			{
				p2_x = tmp_x;
				p2_y = tmp_y;
				r2 = get_point_relation( p2_x , p2_y );
			}
		}


		if( ! r1 && ! r2 )
		{
			p1 -> set( p1_x , p1_y );
			p2 -> set( p2_x , p2_y );

			return( true );
		}
		else
		{
			p1 -> set( 0.0 , 0.0 );
			p2 -> set( 0.0 , 0.0 );

			return( false );
		}
	}
};


#endif	/* D2_RECTANGLE_REGION_H_INCLUDED */
