#ifndef	   FUSE_XML_H_INCLUDED
#define	   FUSE_XML_H_INCLUDED

// Author:		H. Shimora
// Created:		Aug 30 2009
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Aug 30 2009    base version.
//
//

#define FUSE_USE_VERSION 26
#include <fuse.h>

#include <sys/stat.h>
#include <cstddef>
#include <string>
#include <vector>

namespace fuse_xml {

class FuseXML
{
private:
    FuseXML(); // don't allow instantiation

public:
    static struct fuse_operations getFuseOperations();

private:
    static void getPathInfo( std::vector<std::string> * hier,
                             const std::string & path );

public:
    static int getattr( const char * path,
                        struct stat * stat_buf );

    static int open( const char * path,
                     struct fuse_file_info * file_info );

    static int readdir( const char * path,
                        void * buf,
                        fuse_fill_dir_t filler,
                        off_t offset,
                        struct fuse_file_info * file_info );

    static int read( const char * path,
                     char * buf, size_t size,
                     off_t offset,
                     struct fuse_file_info * file_info );
};

} // end of namespace fuse_xml

#endif	/* FUSE_XML_H_INCLUDED */
