#ifndef	   SOCKET_IO_H_INCLUDED
#define	   SOCKET_IO_H_INCLUDED

// Author:		H. Shimora
// Created:		Dec  1 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Dec  1 2002    base version.
//
//

#include  "abstract_io.h"
#include  "stream_socket.h"
#include  <string>


class  Socket_IO : public Abstract_IO
{
private:
	Stream_Socket	socket;

public:
	Socket_IO( const std::string &  host ,  const port_number_t &  port ,
		   bool  ipv4_only )
		: socket( host , port , ipv4_only )
	{
	}

	virtual	~Socket_IO()
	{
	}

	virtual	bool	input_valid() const
	{
		return( this -> socket.valid() );
	}

	virtual	bool	output_valid() const
	{
		return( this -> socket.valid() );
	}

	virtual	int	read( unsigned char * const  buf ,
			      size_t  size )
	{
		return( this -> socket.read( buf , size ) );
	}

	virtual	int	write( const unsigned char * const  buf ,
			       size_t  size )
	{
		return( this -> socket.write_all( buf , size ) );
	}


	virtual	bool	input_eof() const
	{
		return( this -> socket.input_eof() );
	}

	virtual	bool	output_eof() const
	{
		return( this -> socket.output_eof() );
	}

	virtual	bool	output_close()
	{
		return( this -> socket.shutdown( SHUT_WR ) );
	}


	virtual	bool	input_poll() const
	{
		return( this -> socket.poll() );
	}

	virtual	std::vector<int>	input_fds() const
	{
		const int	socket_fd = this -> socket.fd();

		std::vector<int>	vec;

		if ( socket_fd != -1 )
		{
			vec.push_back( socket_fd );
		}

		return( vec );
	}

	virtual	bool	input_close()
	{
		return( this -> socket.shutdown( SHUT_RD ) );
	}
};


#endif	/* SOCKET_IO_H_INCLUDED */
