#ifndef	   SOCKCTL_OPTION_ANALYZER_H_INCLUDED
#define	   SOCKCTL_OPTION_ANALYZER_H_INCLUDED

// Author:		H. Shimora
// Created:		Nov 24 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Nov 24 2002    base version.
//
//

#include  "option_analyzer.h"
#include  "ip_address.h"
#include  <string>
#include  <iostream>

class  Sockctl_Option_Analyzer : public Option_Analyzer
{
private:
	bool		help_;
#ifdef WITH_VERSION_OPTION
	bool		version_;
#endif

	std::string	host_;
	port_number_t	port_;
	bool		ipv4_only_;

	bool		debug_;
	bool		print_io_;


public:
	Sockctl_Option_Analyzer( const std::string &  default_host ,
				 port_number_t  default_port )
		: help_( false ) ,
#ifdef WITH_VERSION_OPTION
		  version_( false ) ,
#endif
		  host_( default_host ) ,
		  port_( default_port ) ,
		  ipv4_only_( false ) ,
		  debug_( false ),
		  print_io_( false )
	{
		add_long_option_flag_on (       "--help"     , &help_ );
#ifdef WITH_VERSION_OPTION
		add_long_option_flag_on (       "--version"  , &version_ );
#endif
		add_option_port_number  ( 'p' , "--port"     , &port_ );
		add_option_string       ( 'h' , "--host"     , &host_ );
		add_short_option_flag_on( '4' ,                &ipv4_only_ );
		add_long_option_flag_on (       "--debug"    , &debug_ );
		add_long_option_flag_on (       "--print-io" , &print_io_ );
	}

	virtual	~Sockctl_Option_Analyzer()
	{
	}

	virtual	bool	check() const
	{
		if ( help_
#ifdef WITH_VERSION_OPTION
		     || version_
#endif
		    )
		{
			return( true );
		}

		return( port_ != 0 );
	}

	virtual	void	usage( std::ostream *  ostr = &std::cerr ) const
	{
		(*ostr)
		   << "Usage: "
		   << this -> program_name()
		   <<   " [OPTION ...] [INPUT_FILE ...]" << std::endl
		   << "Possible options are:" << std::endl
		   << "      --help            "
		   << ": Show usage and exit." << std::endl
		   << std::endl
#ifdef WITH_VERSION_OPTION
		   << "      --version         "
		   << ": Show version of this program and exit." << std::endl
		   << std::endl
#endif
		   << "  -h, --host HOST       "
		   << ": Specify destination host. (default: \"127.0.0.1\")"
		   << std::endl
		   << std::endl

		   << "  -p, --port PORT       "
		   << ": Specify destination port number."
#ifdef DEFAULT_PORT
# if DEFAULT_PORT != 0
		   << " (default: " << DEFAULT_PORT << ")"
# endif
#endif
		   << std::endl
		   << std::endl

		   << "  -4                    "
		   << ": Enforce IPv4 connection." << std::endl
		   << "                          "
		   << "(default: use all available protocols including IPv6)"
		   << std::endl
		   << std::endl

		   << "      --print-io        "
		   << ": Print input/output data."
		   << std::endl

		   << "      --debug           "
		   << ": Print debug information (implies --print-io)."
		   << std::endl;
	}

#ifdef WITH_VERSION_OPTION
	virtual	void	print_version( std::ostream *  ostr = &std::cerr )
									const
	{
		(*ostr)
# ifdef VERSION_STRING
#  define VERSION_STRING_TO_STRING(str) #str
#  define VERSION_STRING_TO_QUOTED_STRING(str) VERSION_STRING_TO_STRING(str)
		    << VERSION_STRING_TO_QUOTED_STRING( VERSION_STRING )
#  undef VERSION_STRING_TO_STRING
#  undef VERSION_STRING_TO_QUOTED_STRING
# else
		    << "?"
# endif
		    << std::endl;
	}
#endif

	virtual	bool	help() const
	{
		return( help_ );
	}

#ifdef WITH_VERSION_OPTION
	virtual	bool	version() const
	{
		return( version_ );
	}
#endif

	virtual	std::string	host() const
	{
		return( host_ );
	}

	virtual	port_number_t	port() const
	{
		return( port_ );
	}

	virtual	bool	ipv4_only() const
	{
		return( ipv4_only_ );
	}

	virtual	bool	debug() const
	{
		return( debug_ );
	}

	virtual	bool	print_io() const
	{
		return( print_io_ );
	}
};


#endif	/* SOCKCTL_OPTION_ANALYZER_H_INCLUDED */
