#include  "test_environment.h"
#include  "path.h"
#include  <string>
#include  <vector>

int    main( void )
{
	Test_Environment	t;

	{
		std::vector<std::string>	path;

		// empty path test
		Path	p1( path );
		t.Assert_Equals( "." , p1.str() );
		t.Assert_Equals( size_t(0) , p1.size() );
		t.Assert_Equals( true , p1.relative() );


		path.push_back( "aaa" );


		Path	p2( path );
		t.Assert_Equals( "aaa" , p2.str() );
		t.Assert_Equals( size_t(1) , p2.size() );
		t.Assert_Equals( true , p2.relative() );


		path.push_back( "bbb" );


		Path	p3( path );
		t.Assert_Equals( "aaa/bbb" , p3.str() );
		t.Assert_Equals( size_t(2) , p3.size() );
		t.Assert_Equals( true , p3.relative() );
		t.Assert_Equals( "aaa" , p3[0] );
		t.Assert_Equals( "bbb" , p3[1] );


		Path	p4 = p2 + p3;
		t.Assert_Equals( "aaa/aaa/bbb" , p4.str() );
		t.Assert_Equals( size_t(3) , p4.size() );
		t.Assert_Equals( true , p4.relative() );


		Path	p5( "aaa/aaa/bbb" );
		t.Assert_Equals( p4 , p5 );
		t.Assert_Not_Equals( p3 , p5 );
		t.Assert_Equals( true , p5.relative() );


		Path	p6( path.begin() , path.end() );
		t.Assert_Equals( p3 , p6 );
		t.Assert_Equals( true , p6.relative() );

		Path	p7( "/aaa/aaa/bbb" );
		t.Assert_Equals( "/aaa/aaa/bbb" , p7.str() );
		t.Assert_Equals( false , p7.relative() );
		t.Assert_Equals( size_t(3) , p7.size() );
		t.Assert_Not_Equals( p5 , p7 );
	}

	return( t.exit_status() );
}
