#ifndef	   AUTO_SELECT_ISTREAM_H_INCLUDED
#define	   AUTO_SELECT_ISTREAM_H_INCLUDED

// Author:		H. Shimora
// Created:		May 22 2006
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 22 2006    base version.
//
//

#include  "istream_compat_wrapper.h"
#include  "comstream.h"
#if ! defined(WITHOUT_MMAP)
#  include  "mmap_fstream.h"
#endif
#include  <fstream>
#include  "string_extension.h"


class  auto_select_istream : public std::istream
{
private:
	ref_count_ptr<std::streambuf>	buf;
	std::string			base_file_name;

private:
	ref_count_ptr<std::filebuf>	filebuf_for_close;

public:
	auto_select_istream( const std::string &  file_name )
		: std::istream( static_cast<std::streambuf *>(0) ) ,
		  base_file_name() ,
		  filebuf_for_close()
	{
		if ( file_name == "-" )
		{
			this -> std::ios::init( std::cin.rdbuf() );
		}
		else if ( String_Extension::ends_with( ".gz" , file_name ) )
		{
			this -> buf = new commandbuf( "gzip" ,
						      "-dc" ,
						      auto_select_istream
						      ::convert_path
							( file_name ).c_str() ,
						      static_cast<char *>(0) );

			this -> std::ios::init( this -> buf.get() );

			this -> base_file_name
				= auto_select_istream
				  ::to_base_file_name( file_name );
		}
		else if ( String_Extension::ends_with( ".bz2" , file_name ) )
		{
			this -> buf = new commandbuf( "bzip2" ,
						      "-dc" ,
						      auto_select_istream
						      ::convert_path
							( file_name ).c_str() ,
						      static_cast<char *>(0) );

			this -> std::ios::init( this -> buf.get() );

			this -> base_file_name
				= auto_select_istream
				  ::to_base_file_name( file_name );
		}
		else if ( String_Extension::ends_with( ".Z" , file_name ) )
		{
			this -> buf = new commandbuf( "uncompress" ,
						      "-c" ,
						      auto_select_istream
						      ::convert_path
							( file_name ).c_str() ,
						      static_cast<char *>(0) );

			this -> std::ios::init( this -> buf.get() );

			this -> base_file_name
				= auto_select_istream
				  ::to_base_file_name( file_name );
		}
		else
		{
#if ! defined(WITHOUT_MMAP)
			ref_count_ptr<mmap_ifstreambuf>	m;
			m = new mmap_ifstreambuf( file_name );
			if ( m -> valid() )
			{
				this -> buf = m;
				this -> std::ios::init( this -> buf.get() );
			}
#else
			ref_count_ptr<std::filebuf>	f = new std::filebuf();

			if ( f -> open( file_name.c_str() , std::ios::in ) )
			{
				this -> buf = f;

				this -> std::ios::init( this -> buf.get() );

				this -> filebuf_for_close = f;
			}
#endif
			this -> base_file_name = file_name;
		}
	}

	virtual	~auto_select_istream()
	{
		if ( this -> filebuf_for_close )
		{
			this -> filebuf_for_close -> close();
		}
	}

	const std::string &	get_base_file_name() const
	{
		return( this -> base_file_name );
	}

private:
	static	std::string	convert_path( const std::string &  file_name )
	{
		if ( ! file_name.empty() && file_name[0] == '-' )
		{
			return( std::string("./") + file_name );
		}
		else
		{
			return( file_name );
		}
	}

	static	std::string	to_base_file_name
				( const std::string &  file_name )
	{
		return( String_Extension::chomp_an_extension( file_name ) );
	}
};

#endif	/* AUTO_SELECT_ISTREAM_H_INCLUDED */
