package daruma.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.FilterInputStream;

public class CountInputStream extends FilterInputStream
{
	private	long	byteCount = 0;
	private	long	markedPoint = 0;

	public	CountInputStream( InputStream  in )
	{
		super( in );
	}

	public	int	read() throws IOException
	{
		int	ret = super.in.read();

		if ( ret != -1 )
		{
			this.byteCount ++;
		}

		return( ret );
	}

	public	int	read( byte[]  b ) throws IOException
	{
		int	ret = super.in.read( b );

		if ( ret != -1 )
		{
			this.byteCount += ret;
		}

		return( ret );
	}

	public	int	read( byte[]  b ,  int  off ,  int  len )
							throws IOException
	{
		int	ret = super.in.read( b , off , len );

		if ( ret != -1 )
		{
			this.byteCount += ret;
		}

		return( ret );
	}


	public	long	skip( long  n ) throws IOException
	{
		long	ret = super.in.skip( n );

		this.byteCount += ret;

		return( ret );
	}

	public	void	mark( int  readlimit )
	{
		super.in.mark( readlimit );

		this.markedPoint = this.byteCount;
	}

	public	void	reset() throws IOException
	{
		this.byteCount = this.markedPoint;
	}


	/**
	 * returns number of read bytes
	 */
	public	long	getByteCount()
	{
		return( this.byteCount );
	}
}
