package daruma.storage_manager.type_definition.types;

import daruma.storage_manager.type_definition.AbstractCompositorTypeDefinition;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.XMLSchemaElementDefinition;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.StorageException;

import daruma.geometry.TransformationContext;

import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.sql.SQLDataType;
import daruma.xml.UniversalName;
import daruma.xml.SimpleXPath;
import daruma.util.Pair;
import daruma.util.LogWriter;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Document;

import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.HashSet;

// XXX: for debug only
import daruma.xml.util.ElementUtil;


public class ChoiceTypeDefinition extends AbstractCompositorTypeDefinition
{
	public	ChoiceTypeDefinition()
	{
		super();
	}

	public List<TableColumnDefinition>
			  getCompositeSQLDataType( StorageManager  storage ,
						   SimpleXPath  path )
							throws TypeException
	{
		List<TableColumnDefinition>
			ret = new ArrayList<TableColumnDefinition>();


		String	indexColumnName;

		if ( path == null )
		{
		    /* !!! [06/08/16 03:26 I.Noda] !!! 
		     * TopLevelEmenentColumnNameFactory 
		     * ColumnNameFactory ѹ
		     */
			indexColumnName = 
			    ColumnNameFactory.getTopLevelElementColumnName();
		}
		else
		{
			SimpleXPath	indexPath = new SimpleXPath( path );

			try
			{
				indexColumnName
				    = storage.getShortXPathStringForDB
								( indexPath );
			}
			catch( StorageException  e )
			{
				throw new TypeException( e );
			}
		}


		ret.add( new TableColumnDefinition
			 ( ColumnNameFactory
			   .getCoiceElementIndexColumnName( indexColumnName ) ,
			   new SQLDataType( "int" , Integer.class ) ) );


		List<TableColumnDefinition>
		 childColumns = super.getCompositeSQLDataType( storage ,
							       path );

		if ( ! this.checkDeterministic( childColumns ) )
		{
			throw new TypeException
				( "ambiguos model, must be deterministic" );
		}

		ret.addAll( childColumns );

		return( ret );
	}

	private	boolean	checkDeterministic
			( List<TableColumnDefinition>  columnDefinitions )
	{
		Set<String>	columnNameDictionary = new HashSet<String>();

		for ( TableColumnDefinition  def  : columnDefinitions )
		{
			String	c = def.getColumnName();

			if ( columnNameDictionary.contains( c ) )
			{
				return( false );
			}

			columnNameDictionary.add( c );
		}

		return( true );
	}


	public	Pair<TypedInstance, Integer>
				createInstance( Element  element ,
						ElementName  topLevelElement ,
						SimpleXPath  path ,
						StorageManager  storage ,
						int  elementIndex )
							  throws TypeException
	{
		LogWriter.qwrite("DEBUG",
				 this.getClass().getName(),
				 ": createInstance()" );
		LogWriter.qwrite("DEBUG",  "elementIndex = ", elementIndex );
		LogWriter.qwrite("DEBUG",  "--" );
		this.debugPrint(); // XXX: use LogWriter
		LogWriter.qwrite("DEBUG",  "--" );
		/* <<< [06/08/17 15:14 I.Noda] <<< */
		//ElementUtil.debugPrint( element , System.err );
		/* === [06/08/17 15:14 I.Noda] === */
		LogWriter.qwrite("DEBUG", element) ;
		/* >>> [06/08/17 15:14 I.Noda] >>> */

		List<TableColumn>  columnList = new ArrayList<TableColumn>();

		SimpleXPath	columnPathBase;

		if ( path != null )
		{
			columnPathBase = new SimpleXPath( path ,
					     new UniversalName( element ) );
		}
		else
		{
			columnPathBase = path;
		}



		List<TableColumnDefinition>
			indexColummns = this.getCompositeSQLDataType
						( storage ,
						  columnPathBase );
		TableColumn	choiceElementIndex
				= new TableColumn( indexColummns.get(0) ,
						   "0" );
		columnList.add( choiceElementIndex );


		NodeList	childNodes   = element.getChildNodes();
		int		nThChildNode = elementIndex;

		int foundDataIndex = -1;
		int i;
		for( i = 0  ;  i < super.getEntries().size()  ;  i ++ )
		{
			Entry	entry  = super.getEntries().get(i);

			//
			// debug print
			//
			if ( entry.isCompositeEntry() )
			{
			    LogWriter.qwrite( "DEBUG",
					      "next entry = composite, ",
					      entry.getCompositeEntry().getClass().getName() );
			}
			else
			{
			    LogWriter.qwrite( "DEBUG",
					      "next entry = atomic" );
			}


			//
			// if composite entry
			//
			if ( entry.isCompositeEntry() )
			{
				Pair<TypedInstance, Integer>	r;

				try
				{
					r = entry.getCompositeEntry()
						  .createInstance
						    ( element ,
						      topLevelElement ,
						      path ,
						      storage ,
						      nThChildNode );
				}
				catch( TypeException  e )
				{
					//
					// ignore this exeption
					//
					// check rest of next candidates

					continue;
				}

				columnList.addAll( r.getFirst().getColumns() );

				LogWriter.qwrite("DEBUG",
						 "nThChildNode updated",
						 " from ", nThChildNode,
						 " to ", r.getSecond() );

				nThChildNode = r.getSecond();

				break;
			}


			//
			// if single entry
			//

			//
			// get next element
			//
			Node	n = null;

			for(;;)
			{
				if ( nThChildNode >= childNodes.getLength() )
				{
					LogWriter.qwrite("DEBUG",
							 "child index = ",
							 nThChildNode, ", ",
							 "number of child nodes = ",
							 childNodes.getLength() );

					throw new TypeException
					  ( "too few child elements of "
					    + new ElementName( element )
								 .toString() );
				}

				n = childNodes.item( nThChildNode );

				if ( n instanceof Element )
				{
					// XXX: check tag equals <annotation>

					break;
				}
				nThChildNode ++;
			}


			Element		childElement = (Element)n;
			ElementName	childElementName = new ElementName
							     ( childElement );

			LogWriter.qwrite("DEBUG",
					 "tag[", nThChildNode, "] = [",
					 childElementName.toString(),
					 "]" );

			ElementName	candidateElementName
					= entry.getAtomEntry()
						.getElementName();

			LogWriter.qwrite("DEBUG",
					 "candidate element = [",
					 candidateElementName, "]" );

			boolean dataExists = true;

			if ( childElementName.equals( candidateElementName ) )
			{
				foundDataIndex = i;
			}
			else
			{
				dataExists = false;
			}

			TypeName	typeName
					= entry.getAtomEntry().getTypeName();

			LogWriter.qwrite("DEBUG",
					 "typeName = [", typeName, "]" );

			TypeDefinition	type;
			try
			{
				type = storage.getTypeDefinition( typeName );
			}
			catch( StorageException  se )
			{
				throw new TypeException( se );
			}

			LogWriter.qwrite("DEBUG",
					 "type.class = ",
					 type.getClass().getName() );

			SimpleXPath	p = new SimpleXPath( path );

			if ( path != null )
			{
				p.add( new UniversalName( element ) );
			}

			TypedInstance	obj = null;
			if ( dataExists )
			{
				try
				{
					obj = type.createInstance
						   ( childElement ,
						     topLevelElement ,
						     p ,
						     storage ,
						     0 ).getFirst();
				}
				catch( TypeException  e )
				{
					throw new TypeException
						  ( e.getMessage(), e );
				}

				columnList.addAll( obj.getColumns() );
			}
			else
			{
			    p.add( candidateElementName );

			    List<TableColumnDefinition> def;

			    if ( type.isSQLMultiColumn() )
			    {				   
				def = type.getCompositeSQLDataType
						  ( storage, p );
			    }
			    else
			    {
				String columnName;

				try
				{
				    columnName
					= storage
					  .getShortXPathStringForDB( p );
				}
				catch( StorageException e )
				{
				    throw new TypeException
					      ( e.getMessage(), e );
				}

				def = new ArrayList<TableColumnDefinition>();
				def.add( new TableColumnDefinition
					 ( columnName,
					   type.getSingleSQLDataType() ) );
			    }

			    for( TableColumnDefinition d : def )
			    {
				columnList.add( new TableColumn( d , null ) );
			    }
			}
		}

		nThChildNode ++;
		if ( foundDataIndex == -1 )
		{
		    // XXX: error
		    assert false;
		}

		LogWriter.qwrite("DEBUG", "");
		LogWriter.qwrite("DEBUG", "");
		LogWriter.qwrite("DEBUG",  "!!!!! INDEX = ", foundDataIndex );
		LogWriter.qwrite("DEBUG", "");
		LogWriter.qwrite("DEBUG", "");

		columnList.get(0).setValue
		    ( Integer.toString( foundDataIndex ) );

		LogWriter.qwrite("DEBUG", "");
		LogWriter.qwrite("DEBUG", "");

		return( new Pair<TypedInstance, Integer>
			( new TypedInstance( columnList , this ) ,
			  nThChildNode ) );
	}


	public int  convertToXMLElement( Element  element ,
					 Document  doc ,
					 StorageManager  storage ,
					 TransformationContext  trans ,
					 List<TableColumn>  columns ,
					 int  index ,
					 long  id ) throws TypeException
	{
		int	i = index;

		String value = columns.get(i).getValue();

		int	dataElementIndex;
		if ( value == null )
		{
		    dataElementIndex = -1;
		}
		else
		{
		    dataElementIndex = Integer.parseInt( value );
		}
		i ++;

		int	elementIndex;
		for( elementIndex = 0  ;
		     elementIndex < this.getEntries().size()  ;
		     elementIndex ++ )
		{
			Entry	e = this.getEntries().get( elementIndex );

			boolean	isDataElement
				= (elementIndex == dataElementIndex);

			if ( e.isCompositeEntry() )
			{
				if ( isDataElement )
				{
					i = e.getCompositeEntry()
					    .convertToXMLElement( element ,
								  doc ,
								  storage ,
								  trans ,
								  columns ,
								  i ,
								  id );
				}
				else
				{
					i += (e.getCompositeEntry()
						.getCompositeSQLDataType
							    ( storage, null )
						.size());
				}
			}

			XMLSchemaElementDefinition	a = e.getAtomEntry();

			TypeName	childTypeName    = a.getTypeName();
			ElementName	childElementName = a.getElementName();

			TypeDefinition	childType;
			try
			{
				childType = storage.getTypeDefinition
							( childTypeName );
			}
			catch( StorageException  se )
			{
				throw new TypeException( se );
			}

			if ( childType.getSingleSQLDataType() != null )
			{
				if ( isDataElement )
				{
					Element	child = doc.createElementNS
					  ( childElementName.getNamespace() ,
					    childElementName.getLocalName() );

					element.appendChild( child );

					child.appendChild( doc.createTextNode
							   ( columns.get(i)
							     .getValue() ) );
				}

				i ++;
			}
			else
			{
				if ( isDataElement )
				{
					Element	child = doc.createElementNS
					  ( childElementName.getNamespace() ,
					    childElementName.getLocalName() );

					element.appendChild( child );

					i = childType.convertToXMLElement
						( child ,
						  doc ,
						  storage ,
						  trans ,
						  columns ,
						  i ,
						  id );
				}
				else
				{
					i += childType.getCompositeSQLDataType
							      ( storage, null )
							.size();
				}
			}
		}

		return( i );
	}
}
