#ifndef	   SYSTEM_CALL_WRAPPER_H_INCLUDED
#define	   SYSTEM_CALL_WRAPPER_H_INCLUDED

// Author:		H. Shimora
// Created:		Aug 22 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Aug 22 2002    base version.
//
//

#include  <sys/types.h>
#include  <string>
#include  <vector>

namespace System_Call_Wrapper
{
	int	execv ( const std::string &  path ,
			const std::vector<std::string> &  argv );

	int	execvp( const std::string &  file_name ,
			const std::vector<std::string> &  argv );

#if ! defined(TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE)
	pid_t	fork_execvp( const std::string &  file_name ,
			     const std::vector<std::string> &  argv );

	pid_t	fork_execvp_wait( const std::string &  file_name ,
				  const std::vector<std::string> &  argv ,
				  int *  status = static_cast<int *>(0) );
#endif
}


#include  <sys/types.h>
#include  <sys/stat.h>

class  Path;

namespace System_Call_Wrapper
{
	int	mkdir  ( const Path &  path ,  mode_t  mode = 0777 ,
			 bool  print_error = true );
	int	mkdir_p( const Path &  path ,  mode_t  mode = 0777 ,
			 bool  print_error = true );

	int	unlink ( const Path &  path ,
			 bool  print_error = true );

	bool	is_directory( const Path &  p );
}


#include  <sys/types.h>
#include  <unistd.h>
#include  <string>
#include  <cstddef>

namespace System_Call_Wrapper
{
	size_t	read_n_bytes( int  fd ,  void *  result ,  size_t  n );
	size_t	read_n_bytes_with_timeout
			    ( int  fd ,  void *  result ,  size_t  n ,
			      long  timeout_msec ,  bool *  timeout );

	size_t	read_n_bytes( int  fd ,  std::string *  result ,  size_t  n );
	size_t	read_n_bytes_with_timeout
			    ( int  fd ,  std::string *  result ,  size_t  n ,
			      long  timeout_msec ,  bool *  timeout );


	size_t	write_n_bytes( int  fd ,  const void *  data ,  size_t  n );

	ssize_t	read( int  fd ,  void *  result ,  size_t  n );
	ssize_t	write( int  fd ,  const void *  data ,  size_t  n );

	void	read_all( int  fd ,  std::string *  result );
}



namespace System_Call_Wrapper
{
	bool	poll_fd( int  fd );
	bool	poll_fd( int  fd ,  long  timeout_msec );

	int	poll( int  fd );
	int	poll( int  fd ,  long  timeout_msec );
}


#endif	/* SYSTEM_CALL_WRAPPER_H_INCLUDED */
