#ifndef	   SOCKSTREAM_H_INCLUDED
#define	   SOCKSTREAM_H_INCLUDED

// Author:		H. Shimora
// Created:		Sep 15 2007
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Sep 15 2007    base version.
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  <iostream>
#include  "sockstreambuf.h"
#include  "ip_address.h"
#include  <string>

class  sockstream : public std::iostream
{
protected:
	sockstreambuf	buf;

public:
	sockstream( const std::string &  host ,
		    port_number_t  port ,
		    bool  ipv4_only = false )
		: std::iostream( static_cast<std::streambuf *>(0) ) ,
		  buf( host , port ,  ipv4_only )
	{
		this -> std::ios::init( &buf );
	}

	sockstream()
		: std::iostream( static_cast<std::streambuf *>(0) ) ,
		  buf()
	{
		this -> std::ios::init( &buf );
	}

	sockstream *	connect( const std::string &  host ,
				 port_number_t  port ,
				 bool ipv4_only = false )
	{
		this -> buf.connect( host , port , ipv4_only );

		return( this );
	}

	void	close()
	{
		buf.close();
	}
};


class  isockstream : public std::istream
{
protected:
	sockstreambuf	buf;

public:
	isockstream( const std::string &  host ,
		     port_number_t  port ,
		     bool  ipv4_only = false )
		: std::istream( static_cast<std::streambuf *>(0) ) ,
		  buf( host , port ,  ipv4_only )
	{
		this -> std::ios::init( &buf );
	}

	isockstream()
		: std::istream( static_cast<std::streambuf *>(0) ) ,
		  buf()
	{
		this -> std::ios::init( &buf );
	}

	isockstream *	connect( const std::string &  host ,
				 port_number_t  port ,
				 bool ipv4_only = false )
	{
		this -> buf.connect( host , port , ipv4_only );

		return( this );
	}

	void	close()
	{
		buf.close();
	}
};


class  osockstream : public std::ostream
{
protected:
	sockstreambuf	buf;

public:
	osockstream( const std::string &  host ,
		     port_number_t  port ,
		     bool  ipv4_only = false )
		: std::ostream( static_cast<std::streambuf *>(0) ) ,
		  buf( host , port ,  ipv4_only )
	{
		this -> std::ios::init( &buf );
	}

	osockstream()
		: std::ostream( static_cast<std::streambuf *>(0) ) ,
		  buf()
	{
		this -> std::ios::init( &buf );
	}

	osockstream *	connect( const std::string &  host ,
				 port_number_t  port ,
				 bool ipv4_only = false )
	{
		this -> buf.connect( host , port , ipv4_only );

		return( this );
	}

	void	close()
	{
		buf.close();
	}
};


#endif	/* SOCKSTREAM_H_INCLUDED */
