#ifndef	   IP_ADDRESS_H_INCLUDED
#define	   IP_ADDRESS_H_INCLUDED

#include  <string>
#include  <iosfwd>

#ifdef HAVE_CONFIG_H
	#include  "config.h"
#else
	#if   defined( HAVE_INTTYPES_H )
		#include  <inttypes.h>
		typedef  uint32_t	ip_address_t;
		typedef  uint16_t	port_number_t;
	#elif defined( __linux )
		typedef  unsigned long	ip_address_t;
		typedef  int		port_number_t;
	#else
		typedef  unsigned long	ip_address_t;
		typedef  unsigned short	port_number_t;
	#endif
#endif


//
// Internet Protocol(Version 4) Address class
//
class  IPv4_Address
{
public:
	enum Byte_Order { Network_Byte_Order , Host_Byte_Order };

protected:
	// host byte order
	ip_address_t	address;

public:
	IPv4_Address( unsigned char  a ,  unsigned char  b ,
		      unsigned char  c ,  unsigned char  d );

	IPv4_Address( const std::string &  host );

	IPv4_Address( Byte_Order  order ,  ip_address_t  addr );

	IPv4_Address( const IPv4_Address &  ip )
		: address( ip.address )
		{
		}

	ip_address_t	host_byte_order() const;
	ip_address_t	network_byte_order() const;

	operator std::string() const;

	bool	operator == ( const IPv4_Address &  addr ) const
	{
		return( this -> address == addr.address );
	}

#if 0
	operator ip_address_t() const
		{
			return( this -> network_byte_order() );
		}
#endif
};

extern	std::ostream &  operator<< ( std::ostream &  ostrm ,
				     const IPv4_Address &  addr );


#endif	/* IP_ADDRESS_H_INCLUDED */
