#include  "sample_interpreter.h"
#include  "general_server.h"
#include  "general_server_option_analyzer.h"
#include  "process_environment.h"
#include  <sys/time.h>		// for getpriority(), setpriority()
#ifdef HAVE_SYS_RESOURCE_H
#  include  <sys/resource.h>	// for getpriority(), setpriority()
#endif
#include  <errno.h>		// for errno
#include  <csignal>		// for signal()
#include  <cstdlib>		// for daemon()
#include  <cstdio>		// for perror()
#include  <exception>
#include  <iostream>


static	const	port_number_t	DEFAULT_PORT = 1234;

int    main( int  argc ,  char *  argv[] )
{
  try
  {
	//
	// option analysis
	//
#ifdef TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE
	General_Server_Option_Analyzer	opt( DEFAULT_PORT );
#else
	General_Server_Option_Analyzer	opt( DEFAULT_PORT ,
					     PRIO_MAX ,
					     /* debug */ false );
#endif

	if ( ! opt.analyze( argc , argv ) )
	{
		opt.usage();
		return( 1 );
	}
	else if ( opt.help() )
	{
		opt.usage();
		return( 0 );
	}


	//
	// signal handling
	//
	if ( ! opt.debug() )
	{
#ifdef TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE
		if ( std::signal( SIGINT  , SIG_IGN ) == SIG_ERR )
#else
		if ( std::signal( SIGPIPE , SIG_IGN ) == SIG_ERR
		  || std::signal( SIGHUP  , SIG_IGN ) == SIG_ERR
		  || std::signal( SIGINT  , SIG_IGN ) == SIG_ERR
		  || std::signal( SIGQUIT , SIG_IGN ) == SIG_ERR )
#endif
		{
			std::perror( "signal" );

			return( 1 );
		}
	}


	//
	// make daemon environment
	//
	if ( ! opt.debug() )
	{
		if ( ! Process_Environment::switch_to_daemon_environment() )
		{
			return( 1 );
		}
	}


#ifndef TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE
	//
	// renice process
	//
	{
		errno = 0;
		int	priority = ::getpriority( PRIO_PROCESS , 0 );

		if ( errno != 0 )
		{
			std::perror( "getpriority" );

			return( 1 );
		}

		if ( opt.bind_fd() != -1
		  && ::setpriority( PRIO_PROCESS ,
				    0 , priority + opt.nice() ) != 0 )
		{
			std::perror( "setpriority" );

			return( 1 );
		}
	}
#endif


	//
	// initialize socket system
	//
	std::string	error_message;
	if ( ! Socket_System_Environment::initialize( &error_message ) )
	{
		std::cerr << "socket initialize error: " << error_message
			  << std::endl;
		return( 1 );
	}


	//
	// run daemon
	//
	General_Server	sample_server
			( new Sample_Interpreter_Factory ,
			  static_cast<General_Server_Default_Action *>(0) ,
			  opt.port() , opt.argv() , opt.bind_fd() );

	sample_server.run();


	//
	// finalize socket system
	//
	if ( ! Socket_System_Environment::finalize( &error_message ) )
	{
		std::cerr << "socket finalize error: " << error_message
			  << std::endl;
		return( 1 );
	}
  }
  catch( const std::exception &  e )
  {
	if ( *(e.what()) != '\0' )
	{
		std::cerr << e.what() << std::endl;
	}
  }
  catch(...)
  {
	std::cerr << "exception caught!!" << std::endl;
  }

  return( 0 );
}
