#include  "base64_table.h"
#include  <cstring>

const char *	Base64_Table::table = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
				      "abcdefghijklmnopqrstuvwxyz"
				      "0123456789"
				      "+/";

const char	Base64_Table::padding = '=';

Base64_Table::Base64_Table()
	: char_map()
{
	for ( size_t  i = 0  ;  i < std::strlen( table )  ;  i ++ )
	{
		char_map[ table[i] ] = i;
	}
}

bool   Base64_Table::char_to_index( unsigned char *  indx ,  char  ch ) const
{
	Char_Map_Type::const_iterator	it = this -> char_map.find( ch );

	if ( it == this -> char_map.end() )
	{
		*indx = 0;

		return( false );
	}

	*indx = (*it).second;

	return( true );
}
