#ifndef	   PATH_H_INCLUDED
#define	   PATH_H_INCLUDED

// Author:		H. Shimora
// Created:		Oct 17 2004
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Oct 17 2004    base version.
//
//

#include  <string>
#include  <vector>
#include  <iosfwd>


class  Path
{
public:
	static const std::string	SEPARATOR;

private:
	std::vector<std::string>	path;
	bool				relative_flag;


public:
	Path( const std::vector<std::string> &  path ,
	      bool  relative_flag = true );
	Path( const std::string &  path_string );
	Path( const std::vector<std::string>::const_iterator &  begin ,
	      const std::vector<std::string>::const_iterator &  end ,
	      bool  relative_flag = true );

	bool	valid() const;

	bool	relative() const;
	bool	absolute() const;

	size_t	size() const;
	const std::string &	operator[] ( size_t  i ) const;

	std::string	str() const;
	std::string	native_string() const;

	Path		dir() const;
	std::string	file() const;

	operator std::vector<std::string>() const;

	Path	add( const Path &  p ) const;
	Path	operator + ( const Path &  p ) const;

	bool	operator == ( const Path &  p ) const;
	bool	operator != ( const Path &  p ) const;

	operator std::string() const;

public:
	static	Path	CURRENT_DIR();
};


extern	std::ostream &  operator<< ( std::ostream &  ostrm ,
				     const Path &  path );


#endif	/* PATH_H_INCLUDED */
