#include  "sample_option_analyzer.h"
#include  <iostream>
#include  <vector>
#include  <string>
#include  <cstdlib>

using namespace std;

int    main( int  argc ,  char *  argv[] )
{
	Sample_Option_Analyzer	opt;

	if ( ! opt.analyze( argc , argv ) )
	{
		opt.usage();
		return( 1 );
	}
	else if ( opt.help() )
	{
		opt.usage();
		return( 0 );
	}


	std::cout << "flag = " << (opt.flag() ? "true" : "false") << std::endl;
	std::cout << "integer = " << opt.integer() << std::endl;
	std::cout << "float = " << opt.flt() << std::endl;
	std::cout << "str = [" << opt.str() << "]" << std::endl;

	for ( size_t  i = 0  ;  i < opt.raw_arguments().size()  ;  i ++ )
	{
		cout << "raw_arguments[" << i << "] = "
		     << "[" << opt.raw_arguments()[i] << "]" << endl;
	}

	vector<string>	rest = opt.rest_options();

	for ( size_t  i = 0  ;  i < rest.size()  ;  i ++ )
	{
		cout << "rest[" << i << "] = "
		     << "[" << rest[i] << "]" << endl;
	}

	return( 0 );
}
