#include  "test_environment.h"
#include  "compat_stringstream.h"
#include  "ip_address.h"
#include  <string>

int    main( void )
{
	Test_Environment	t;

	{
		// equal test
		IPv4_Address	addr_1(  127,0,0,1 );
		IPv4_Address	addr_2( "127.0.0.1" );
		t.Assert_Equals( addr_1 , addr_2 );

		IPv4_Address	addr_3( addr_1 );
		t.Assert_Equals( addr_1 , addr_3 );


		// string
		t.Assert_Equals( "127.0.0.1" , addr_1 );
		t.Assert_Equals( "127.0.0.1" , addr_2 );


		// ostream
		compat_ostringstream	str1;
		compat_ostringstream	str2;
		str1 << addr_1;
		str2 << addr_2;

		t.Assert_Equals( "127.0.0.1" , str1.str() );
		t.Assert_Equals( "127.0.0.1" , str2.str() );
	}

	return( t.exit_status() );
}
