#ifndef	   IOSTREAM_EXTENSION_H_INCLUDED
#define	   IOSTREAM_EXTENSION_H_INCLUDED

// Author:		H. Shimora
// Created:		Jan  4 2005
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jan  4 2005    base version.
//
//

#include  <string>
#include  <iostream>
#include  <fstream>

namespace  IOStream_Extension
{


	inline
	void	read_all( std::string *  result ,  std::istream &  in )
	{
		for(;;)
		{
			unsigned char	ch = in.get();

			if ( ! in || in.eof() )
			{
				break;
			}

			(*result) += ch;
		}
	}


	inline
	void	copy_all( std::istream &  in ,  std::ostream &  out )
	{
		// XXX: use streambuf_iterator if available

		for(;;)
		{
			unsigned char	ch = in.get();

			if ( ! in || in.eof() )
			{
				break;
			}

			out.put( ch );
		}

		out.flush();
	}


	inline
	void	write_all( const std::string &  input ,  const char *  path )
	{
		std::ofstream	file( path );

		file << input;

		file.flush();
	}


	inline
	void	indent( std::ostream &  ostrm ,
			size_t  indent_level ,
			const std::string &  indent_str = "\t" )
	{
		for ( size_t  i = 0  ;  i < indent_level  ;  i ++ )
		{
			ostrm << indent_str;
		}
	}


} // end of namespace IOStream_Extension


#endif	/* IOSTREAM_EXTENSION_H_INCLUDED */
