#include  "d2_segment.h"
#include  "test_environment.h"

int    main( void )
{
	Test_Environment	t;


	{
		const D2_Segment	s1( D2_Vector( 0.0 , 0.0 ) ,
					    D2_Vector( 3.0 , 4.0 ) );

		{
			ASSERT
			( t.Assert_Nearly_Equals( 5.0 , s1.length() ) );
		}


		const D2_Segment	s2( D2_Vector( 0.0 , 2.0 ) ,
					    D2_Vector( 5.0 , 2.0 ) );
		{
			ASSERT( t.Assert( s1.intersect_without_terminal_point
					  ( s2 ) ) );
			ASSERT( t.Assert( s2.intersect_without_terminal_point
					  ( s1 ) ) );
		}


		const D2_Segment	s3( D2_Vector( 100.0 , 200.0 ) ,
					    D2_Vector( 300.0 , 400.0 ) );

		{
			ASSERT
			( t.Assert
			  ( ! s3.intersect_without_terminal_point( s1 ) ) );
			ASSERT
			( t.Assert
			  ( ! s3.intersect_without_terminal_point( s2 ) ) );

			ASSERT
			( t.Assert
			  ( ! s1.intersect_without_terminal_point( s3 ) ) );
			ASSERT
			( t.Assert
			  ( ! s2.intersect_without_terminal_point( s3 ) ) );
		}


		// 2 segments on a line
		const D2_Segment	s1_2( D2_Vector( 6.0 ,  8.0 ) ,
					      D2_Vector( 9.0 , 12.0 ) );

		{
			ASSERT
			( t.Assert
			  ( ! s1.intersect_without_terminal_point( s1_2 ) ) );
			ASSERT
			( t.Assert
			  ( ! s1_2.intersect_without_terminal_point( s1 ) ) );
		}


		const D2_Segment	s4( D2_Vector( -100.0 , 4.0 ) ,
					    D2_Vector( +100.0 , 4.0 ) );
		{
			ASSERT( t.Assert( s1.intersect( s4 ) ) );
			ASSERT( t.Assert( s4.intersect( s1 ) ) );
		}


		{
			const D2_Segment
				t1( D2_Vector( -200.0 , -100.0 ) ,
				    D2_Vector(    0.0 , +100.0 ) );

			const D2_Segment
				t2( D2_Vector(    0.0 , +100.0 ) ,
				    D2_Vector( +200.0 , -100.0 ) );

			const D2_Segment
				t_check( D2_Vector( 0.0 , -300.0 ) ,
					 D2_Vector( 0.0 , +900.0 ) );

			ASSERT( t.Assert( t1.intersect( t_check ) ) );
			ASSERT( t.Assert( t_check.intersect( t1 ) ) );

			ASSERT( t.Assert( t2.intersect( t_check ) ) );
			ASSERT( t.Assert( t_check.intersect( t2 ) ) );
		}

		{
			const D2_Segment	t1( D2_Vector( 100 , 100 ) ,
						    D2_Vector(   0 , 200 ) );

			const D2_Segment	t2( D2_Vector( -100 , 200 ) ,
						    D2_Vector(  600 , 200 ) );

			ASSERT( t.Assert( t1.intersect( t2 ) ) );
			ASSERT( t.Assert( t2.intersect( t1 ) ) );
		}

		// intersect with terminal points
		{
			const D2_Segment	t1( D2_Vector(  200 , 100 ) ,
						    D2_Vector( 2000 , 100 ) );

			const D2_Segment	t2( D2_Vector(  200 , 100 ) ,
						    D2_Vector(  200 , 500 ) );

			ASSERT( t.Assert( t1.intersect( t2 ) ) );
			ASSERT( t.Assert( t2.intersect( t1 ) ) );
		}

		// intersect with terminal points (parallel, horizontal)
		{
			const D2_Segment	t1( D2_Vector( +200 , +100 ) ,
						    D2_Vector( +500 , +100 ) );

			const D2_Segment	t2( D2_Vector( +200 , +100 ) ,
						    D2_Vector( -100 , +100 ) );

			ASSERT( t.Assert( t1.intersect( t2 ) ) );
			ASSERT( t.Assert( t2.intersect( t1 ) ) );
		}

		// intersect with terminal points (parallel, vertical)
		{
			const D2_Segment	t1( D2_Vector( +100 , +200 ) ,
						    D2_Vector( +100 , +500 ) );

			const D2_Segment	t2( D2_Vector( +100 , +200 ) ,
						    D2_Vector( +100 , -100 ) );

			ASSERT( t.Assert( t1.intersect( t2 ) ) );
			ASSERT( t.Assert( t2.intersect( t1 ) ) );

			ASSERT( t.Assert_Nearly_Equals( 0.0 ,
							t1.distance( t2 ) ) );
			ASSERT( t.Assert_Nearly_Equals( 0.0 ,
							t2.distance( t1 ) ) );
		}

		// intersect with point segment 1
		{
			const D2_Segment	t1( D2_Vector( 0 ,    0 ) ,
						    D2_Vector( 0 , +500 ) );

			const D2_Segment	t2( D2_Vector( +100 , +500 ) ,
						    D2_Vector( +100 , +500 ) );


			ASSERT( t.Assert( ! t1.intersect( t2 ) ) );
			ASSERT( t.Assert( ! t2.intersect( t1 ) ) );
		}

		// intersect with point segment 2
		{
			const D2_Segment	t1( D2_Vector( +500 , +500 ) ,
						    D2_Vector( +500 , +500 ) );

			const D2_Segment	t2( D2_Vector( +300 , +500 ) ,
						    D2_Vector( +200 , +400 ) );


			ASSERT( t.Assert( ! t1.intersect( t2 ) ) );
			ASSERT( t.Assert( ! t2.intersect( t1 ) ) );
		}

		// intersect with point segment 3
		{
			const D2_Segment	t1( D2_Vector( +500 , +500 ) ,
						    D2_Vector( +500 , +500 ) );

			const D2_Segment	t2( D2_Vector( +300 , +300 ) ,
						    D2_Vector( +300 , +300 ) );


			ASSERT( t.Assert( ! t1.intersect( t2 ) ) );
			ASSERT( t.Assert( ! t2.intersect( t1 ) ) );

			ASSERT( t.Assert( t1.intersect( t1 ) ) );
			ASSERT( t.Assert( t2.intersect( t2 ) ) );
		}

		// intersect with point segment 4
		{
			const D2_Segment	t1( D2_Vector( +500 , +500 ) ,
						    D2_Vector( +500 , +500 ) );

			const D2_Segment	t2( D2_Vector(    0 , +500 ) ,
						    D2_Vector( +100 , +500 ) );


			ASSERT( t.Assert( ! t1.intersect( t2 ) ) );
			ASSERT( t.Assert( ! t2.intersect( t1 ) ) );
		}

		// intersect with point segment 5
		{
			const D2_Segment	t1( D2_Vector( +500 , +500 ) ,
						    D2_Vector( +500 , +500 ) );

			const D2_Segment	t2( D2_Vector( +500 ,    0 ) ,
						    D2_Vector( +500 , +100 ) );

			ASSERT( t.Assert( ! t1.intersect( t2 ) ) );
			ASSERT( t.Assert( ! t2.intersect( t1 ) ) );
		}

		// middle point
		{
			const D2_Segment
				s( D2_Vector( +100.0 , 100.0 ) ,
				   D2_Vector( +500.0 , 300.0 ) );

			ASSERT(	t.Assert_Nearly_Equals
				( 0.0 ,
				  (s.middle_point()
				   - D2_Vector( 300.0 , 200.0 ) ).r() ) );
		}

		// closest point
		{
			const D2_Vector	s1( -500 , 100 );
			const D2_Vector	s2( +500 , 100 );

			const D2_Segment	s( s1 , s2 );

			ASSERT( t.Assert_Nearly_Equals
				( 0.0 ,
				  (s.nearest_point( D2_Vector( 0.0 , 0.0 ) )
				   - D2_Vector( 0.0 , 100.0 ) ).r() ) );

			ASSERT( t.Assert_Nearly_Equals
				( 0.0 ,
				  (s.nearest_point
				   ( D2_Vector( 200.0 , 0.0 ) )
				   - D2_Vector( 200.0 , 100.0 ) ).r() ) );

			for ( long  i = 0  ;  i < 100000  ;  i += 10 )
			{
				const D2_Vector		p( i , +500 );

				D2_Vector	c;

				if ( i <= 500 )
				{
					c = s.nearest_point( +p );

					ASSERT( t.Assert_Nearly_Equals
						( 0.0 ,
						  (D2_Vector( (+p).x() , 100 )
						   - c).r() ) );

					c = s.nearest_point( -p );

					ASSERT( t.Assert_Nearly_Equals
						( 0.0 ,
						  (D2_Vector( (-p).x() , 100 )
						   - c).r() ) );
				}
				else
				{
					c = s.nearest_point( +p );

					ASSERT( t.Assert_Nearly_Equals
						( 0.0 , (s2 - c).r() ) );

					c = s.nearest_point( -p );

					ASSERT( t.Assert_Nearly_Equals
						( 0.0 , (s1 - c).r() ) );
				}
			}
		}


		// distance from segment
		{
			const D2_Vector	s1( -100 , 0 );
			const D2_Vector	s2( +100 , 0 );

			const D2_Segment	seg( s1 , s2 );

			const D2_Vector		p1( 0 , +150 );

			ASSERT( t.Assert_Nearly_Equals
				( 150.0 , seg.distance( +p1 ) ) );
			ASSERT( t.Assert_Nearly_Equals
				( 150.0 , seg.distance( -p1 ) ) );

			const D2_Vector		p2( 300 , 0 );
			ASSERT( t.Assert_Nearly_Equals
				( 200.0 , seg.distance( +p2 ) ) );
			ASSERT( t.Assert_Nearly_Equals
				( 200.0 , seg.distance( -p2 ) ) );

			const D2_Vector		p3( 20000 , 0 );
			ASSERT( t.Assert_Nearly_Equals
				( 19900.0 , seg.distance( +p3 ) ) );
			ASSERT( t.Assert_Nearly_Equals
				( 19900.0 , seg.distance( -p3 ) ) );

			for ( long  i = 0  ;  i < 100000  ;  i += 10 )
			{
				const D2_Vector		p( i , +500 );

				if ( i <= 100 )
				{
					ASSERT( t.Assert_Nearly_Equals
						( 500 ,
						  seg.distance( +p ) ) );

					ASSERT( t.Assert_Nearly_Equals
						( 500 ,
						  seg.distance( -p ) ) );
				}
				else
				{
					ASSERT( t.Assert_Nearly_Equals
						( (s2 - p).r() ,
						  seg.distance( +p ) ) );

					ASSERT( t.Assert_Nearly_Equals
						( (s1 - (-p)).r() ,
						  seg.distance( -p ) ) );
				}
			}
		}

		// distance from point
		{
			const D2_Segment    seg( D2_Vector( -100.0 , 0.0 ) ,
						 D2_Vector(    0.0 , 0.0 ) );

			const D2_Vector		p( 400.0 , 300.0 );

			ASSERT( t.Assert_Nearly_Equals
				( 500.0 , seg.distance( p ) ) );
		}

		// distance from point
		{
			const D2_Segment    seg( D2_Vector(    0.0 , 0.0 ) ,
						 D2_Vector( -100.0 , 0.0 ) );

			const D2_Vector		p( 400.0 , 300.0 );

			ASSERT( t.Assert_Nearly_Equals
				( 500.0 , seg.distance( p ) ) );
		}

		// distance from point
		{
			const D2_Segment	seg( D2_Vector( -100 , 0.0 ) ,
						     D2_Vector( +100 , 0.0 ) );

			const D2_Vector		p( +150.0 , 0.0 );

			ASSERT( t.Assert_Nearly_Equals
				( 50.0 , seg.distance( p ) ) );

			ASSERT( t.Assert_Nearly_Equals
				( 250.0 , seg.farthest_distance( p ) ) );
		}

		// on segment
		{
			const D2_Segment    seg( D2_Vector( -100.0 , 0.0 ) ,
						 D2_Vector( +100.0 , 0.0 ) );

			const D2_Vector		p0( 0.0 , 0.0 );
			const D2_Vector		p1( 0.0 , 1.0 );

			ASSERT( t.Assert_Equals
				( true  , seg.on_segment( p0 ) ) );
			ASSERT( t.Assert_Equals
				( false , seg.on_segment( p1 ) ) );
		}

		// on segment
		{
			const D2_Segment    seg( D2_Vector( -100.0 , 0.0 ) ,
						 D2_Vector( +100.0 , 0.0 ) );

			const D2_Vector		p( 0.0 , 0.5 );

			ASSERT( t.Assert_Equals
				( true  , seg.on_segment( p , 1.0 ) ) );
			ASSERT( t.Assert_Equals
				( false , seg.on_segment( p , 0.1 ) ) );
		}

		// distance segment and segment
		{
			const D2_Segment    seg( D2_Vector( +100.0 , 100.0 ) ,
						 D2_Vector( -100.0 , 100.0 ) );

			const D2_Segment    s( D2_Vector(    0.0 , 300.0 ) ,
					       D2_Vector( +100.0 , 400.0 ) );

			ASSERT( t.Assert_Nearly_Equals
				( 200.0 , seg.distance( s ) ) );
			ASSERT( t.Assert_Nearly_Equals
				( 200.0 , s.distance( seg ) ) );
		}
	}


	return( t.exit_status() );
}
