require 'darkhall/lang'

#　定数
module DarkHall
	SCREEN_WIDTH = 640
	SCREEN_HEIGHT = 480
	
	VERSION = 'Beta period 10'
	VERSION_CODE = 'b10'
	WINDOW_CAPTION = _("DarkHall %{version}") % {:version => VERSION}
	
	DEFAULT_TTF_NAME = 'ume-tgc5.ttf'
	DEFAULT_TTF_SIZE = 14
	
	FPS = 30
	
	# 主にGame.timelogで使う
	TIMELOG_FORMAT = "%s: %.3g sec"

	
	# セーブ頻度
	FQ_QUIT = 10
	FQ_BIG_CHANGE = 20
	FQ_CHANGE = 30
	FQ_SMALL_CHANGE = 40
	FQ_MINIMUM = 10
	FQ_MAXIMUM = 40
	
	# 時間
	WEEK_PER_YEAR = 50
	
	# アイテムの鑑定コスト
	IDENTIFICATION_COST = 3


	
	# キーの順番（呪文やアイテムのショートカットで利用）
	KEY_TABLE = %w(A S D F G H J K L +)


	# 方角
	DIR_N = 0
	DIR_W = 3
	DIR_E = 1
	DIR_S = 2
	
	# 戦闘の勝敗
	BR_WIN = :Win
	BR_PARTY_ESCAPE = :PartyEscape
	BR_TROOP_ESCAPE = :TroopEscape
	BR_WIPEOUT = :Wipeout
	
	
	# 敵の数
	NUM_ONE = 0
	NUM_E = 1
	NUM_D = 2
	NUM_C = 3
	NUM_B = 4
	NUM_A = 5
	
	NUMBER_LIST_TABLE = {
		NUM_ONE => [1],
		NUM_E => (2..3).to_a, # expect: 2.5
		NUM_D => (2..4).to_a, # expect: 3
		NUM_C => (3..4).to_a, # expect: 3.5
		NUM_B => (3..5).to_a, # expect: 4
		NUM_A => (4..6).to_a, # expect: 5
	}

	
	ITEM_MAX = 10
	DUNGEON_PARTIES_MAX = 3
	MEMBER_MAX = 6
	ENCOUNT_BORDER_DEFAULT = 100
	NAME_LENGTH_MAX = 20
	GOLD_MAX = 99999999
	
	
	VIEWABLE_FRONT_RANGE = 5
	VIEWABLE_SIDE_RANGE = 4
		

	
	CHAR_LENGTH_TABLE = {}
	CHAR_LENGTH_TABLE[1] = 1
	CHAR_LENGTH_TABLE[2] = 2
	CHAR_LENGTH_TABLE[3] = 2
		

	module Section
		TOWN = 1
		DUNGEON = 2
		BATTLE = 3
	end
	
	# 色テーブル
	module Color
		WHITE = [255, 255, 255]
		BLACK = [0, 0, 0]
		YELLOW = [255, 255, 0]
		BLUE = [160, 160, 255]
		AQUA = [0xcc, 0xcc, 0xff]
		GOOD = AQUA
		LIGHT_GREEN = [60, 255, 60]
		RED = [255, 100, 100]
		BAD = RED
		GRAY = [136, 136, 136]
		DISABLE = GRAY

		DOOR = [60, 50, 20]		
		BACK = [0, 0, 0]
		
		MAP = [0xa0, 0xa0, 0xf0]
		MAP_ROOM = [0x80, 0x80, 0xf0]

		MAP_GRID = [0, 60, 0]
	
		SELECT = [0, 0, 200]
	end
	
	ColorTable = Color
	
	
	# 成長値
	GLOW_SS = 8
	GLOW_S = 7
	GLOW_A = 6
	GLOW_B = 5
	GLOW_C = 4
	GLOW_D = 3
	GLOW_E = 2
	GLOW_F = 1
	GLOW_G = 0
	
	
	# 経験値テーブル
	EXP_TABLE = []
	EXP_NEXT_TABLE = []
	LEVEL_MAX = 13
	EXP_TABLE[1] = 0
	
	exp_base = 100
	rate_start = 1.4
	rate_dec = 0.005

	
	
	EXP_TABLE[2] = EXP_NEXT_TABLE[2] = exp_base
	(3..50).each do |next_level|
		current_level = next_level - 1
		rate = rate_start - ((next_level - 3) * rate_dec)
		
		EXP_NEXT_TABLE[next_level] = (EXP_NEXT_TABLE[current_level] * rate).to_i
		EXP_TABLE[next_level] = EXP_TABLE[current_level] + EXP_NEXT_TABLE[next_level]
	end
	
	EXP_TABLE[50] = 99999999
	EXP_NEXT_TABLE[50] = EXP_TABLE[50] - EXP_TABLE[49]


	
	


	# 技能値テーブル
	SP_TABLE = []
	SP_NEXT_TABLE = []
	SP_MAX = 99
	SP_TABLE[0] = 0
	SP_TABLE[1] = SP_NEXT_TABLE[1] = 20
	(2..SP_MAX).each do |i|
		SP_NEXT_TABLE[i] = SP_NEXT_TABLE[i-1] + (4 * (i ** 1.7)).to_i
		SP_TABLE[i] = SP_TABLE[i-1] + SP_NEXT_TABLE[i]
	end

	# 商品タイプ
	PD_WEAPON = 1
	PD_ARMOR = 2
	PD_GOODS = 3
	PD_ACCESSORY = 4
	PD_FIND = 5
	PD_DEBUG = 6
	
	# ダメージ種別
	DT_SLASH = 1    # 斬撃
	DT_THRUST = 2   # 刺突
	DT_BLOW = 3     # 打撃
	DT_HEAT = 4     # 熱
	DT_COLD = 5     # 冷気
	DT_ENERGY = 6   # 魔法的エネルギー
	DT_ERECTRIC = 7 # 電気
	DT_LIGHT = 8    # 光
	DT_GRAVITY = 9  # 重力
	
	# ダメージ耐性
	RES_CRITICAL = 0    # 3.0倍
	RES_VERY_WEAK = 1   # 2倍
	RES_WEAK = 2        # 1.5倍
	RES_NORMAL = 3      # 1倍
	RES_STRONG = 4      # 0.6倍
	RES_VERY_STRONG = 5 # 0.3倍
	RES_PERFECT = 6     # 0倍
	
	RES_X_STRONG = RES_VERY_STRONG
	RES_X_WEAK = RES_VERY_WEAK

	
	RES_DAMAGE_RATE_TABLE = [3.0, 2.0, 1.5, 1.0, 0.6, 0.3, 0]
	RES_STATE_BORDER_BONUS_TABLE = [+999, +30, +15, 0, -15, -30, -999]
	RES_CLEAN_HIT_BORDER_TABLE = [35, 30, 25, 20, 18, nil, nil]
	
	
	# キャラクターの位置
	POS_FORWARD = 1
	POS_BACK = 2
	
	# 敵の出現率
	module EnemyAppearance
		CERTAIN = :certain
		MUCH = :much
		MEDIUM = :medium
		LITTLE = :little
		VERY_LITTLE = :very_little
		NOTHING = :nothing
	end
	
	EA = EnemyAppearance
	
	EA_TABLE = {
		:certain => 100,
		:much => 90,
		:medium => 75,
		:little => 50,
		:very_little => 30,
		:nothing => 0
	}
	
	# 熟練タイプ
	module MasteryType
		WEAPON = 'weapon'
		ARMOR = 'armor'
		SHIELD = 'shield'
		SPELL = 'spell'
	end
	
	MST = MasteryType

	
	
	# 技能種別
	module SkillType
		UNLOCK = 'unlock'
		REMOVE_TRAP = 'remove_trap'
	end
	
	SKILL = SkillType


	# 年齢タイプ	
	module AgeType
		CHILD = 'child'
		YOUNG = 'young'
		ELDER = 'elder'
		OLD = 'old'
	end
	
	AGE = AgeType

	
	# 能力値の種別
	module AbilityType
		STR = 'str'
		TEC = 'tec'
		AGL = 'agl'
		WIL = 'wil'
		PSY = 'psy'
	end
	
	STR = AbilityType::STR
	TEC = AbilityType::TEC
	AGL = AbilityType::AGL
	WIL = AbilityType::WIL
	PSY = AbilityType::PSY
	
	ABILITY_TYPES = [STR, TEC, AGL, WIL, PSY]
	
	ABILITY_CAPTIONS = {}
	ABILITY_CAPTIONS[AbilityType::STR] = _('筋力')
	ABILITY_CAPTIONS[AbilityType::TEC] = _('器用さ')
	ABILITY_CAPTIONS[AbilityType::AGL] = _('素早さ')
	ABILITY_CAPTIONS[AbilityType::WIL] = _('集中力')
	ABILITY_CAPTIONS[AbilityType::PSY] = _('霊感')
	
	BONUS_METHOD_NAME_TABLE = {}
	BONUS_METHOD_NAME_TABLE[STR] = :str_bonus
	BONUS_METHOD_NAME_TABLE[TEC] = :tec_bonus
	BONUS_METHOD_NAME_TABLE[AGL] = :agl_bonus
	BONUS_METHOD_NAME_TABLE[WIL] = :wil_bonus
	BONUS_METHOD_NAME_TABLE[PSY] = :psy_bonus


	AGE_CAPTIONS = {AGE::CHILD => _('子供'), AGE::YOUNG => _('若者'), AGE::ELDER => _('壮齢'), AGE::OLD => _('老人')}
	
	# 宝箱の種別
	module TreasureType
		WEAPON = 'weapon'
		ARMOR = 'armor'
		ACCESSORY = 'accessory'
		ITEM = 'item'
		POTION = 'potion'
		#NOTHING = 'nothing'
	end
	TRT = TreasureType
	
	# プレイヤー情報
	module PlayerProfileType
		include GetText
		LIST = %w(Walk Win Escape Wipeout GotGold GotGoldFromEnemy GotGoldFromTreasureBox GotGoldFromSelling)
		LIST.each{|x| self.const_set(x, x)}
		
		CAPTIONS = {
			Walk => _('総歩数'),
			Win => _('総勝利回数'),
			Escape => _('総逃走回数'),
			Wipeout => _('全滅回数'),
			GotGold => _('総入手金貨'),
			GotGoldFromEnemy => _('敵からの総入手金貨'),
			GotGoldFromTreasureBox => _('宝箱からの総入手金貨'),
			GotGoldFromSelling => _('売却による総入手金貨'),
		}
		

	end
	PPT = PlayerProfileType
	
	module PlayerRecordType
		LIST = %w(GotTreasure Bought EnemyKill GotGold GotExp)
		LIST.each{|x| self.const_set(x, x)}
	end
	PRT = PlayerRecordType
	

	
	# 冒険者情報
	module MemberProfileType
		LIST = [
			'CreatedWeek',
			'LostWeek',
		
			#'WeaponAttack',   # 武器で攻撃した回数
			#'SpellCast',      # 術を発動した回数
			#'ShieldGuard',    # 盾で防御した回数
			#'CleanHit',       # クリーンヒット発生回数
			#'Block',          # ブロックした回数
			#'UseItem',        # アイテムを使用した回数
			#'Attacked',       # 攻撃を受けた回数
			

			'ForwardRound',   # 前列にいたラウンド数合計
			'BackRound',      # 後列にいたラウンド数合計
			
			'Kill',          # 敵を倒した数
			'Walk',          # 歩数
			'Win',           # 勝利回数
			'Escape',        # 逃走回数
			'Revived',       # 蘇生回数
			'UsedMP',        # 消費MP累計
		]

		LIST.each{|x| self.const_set(x, x)}

	end
	MPT = MemberProfileType
	
	
	# アイテムプレフィックス
	module ItemPrefix
		LIST = %w(
			Standard Broken Good Bad Hard Sharp Light Heavy
			Decorated Sophisticated Cursed Gorgeous Master
		)
		
		LIST.each{|x| self.const_set(x, x)}
		CUSTOMIZABLE = LIST - %w(Broken Bad Master Cursed)
	end
	IP = ItemPrefix
	
	ITEM_PREFIX_CAPTIONS = {
		IP::Standard => '',
		IP::Broken => _('壊れた'),
		IP::Good => _('良質な'),
		IP::Bad => _('粗悪な'),
		IP::Hard => _('頑丈な'),
		IP::Sharp => _('鋭い'),
		IP::Heavy => _('重い'),
		IP::Light => _('軽い'),
		IP::Decorated => _('装飾された'),
		IP::Sophisticated => _('精巧な'),
		IP::Cursed => _('呪われた'),
		IP::Gorgeous => _('豪華な'),
		IP::Master => _('達人の'),
	}
	
	
	# 敵プレフィックス
	module EnemyPrefix
		%w(
			Standard Sleepy Systematic Hungry
		).each{|x| self.const_set(x, x)}
	end
	EP = EnemyPrefix
	
	ENEMY_PREFIX_CAPTIONS = {
		EP::Hungry => _('飢えた'),
		EP::Sleepy => _('寝起きの'),
		EP::Systematic => _('組織立った'),

	}
	
	ITEM_PREFIX_TABLE = []
	ITEM_PREFIX_TABLE.concat([IP::Broken, IP::Standard] * 7)
	ITEM_PREFIX_TABLE.concat([IP::Good, IP::Bad, IP::Decorated, IP::Hard, IP::Sharp, IP::Sophisticated, IP::Light] * 5)
	ITEM_PREFIX_TABLE.concat([IP::Heavy, IP::Gorgeous] * 3)
	ITEM_PREFIX_TABLE.concat([IP::Master] * 1)


	# 罠
	module TrapType
		%w(
			Stone Needle MiniBomb PoisonNeedle
			Burner MiniTereporter Alarm BigAlarm
			Tereporter
		).each{|x| self.const_set(x, x)}
	end
	TT = TrapType
	
	TRAP_TYPES = [TT::Stone, TT::Needle, TT::Burner, TT::PoisonNeedle, TT::MiniBomb, TT::Alarm, TT::MiniTereporter]
	
	TRAP_NAMES = {
		TT::Stone => _('石つぶて'),
		TT::Needle => _('ニードル'),
		TT::MiniBomb => _('小型爆弾'),
		TT::PoisonNeedle => _('ポイズンニードル'),
		TT::Burner => _('バーナー'),
		TT::Alarm => _('アラーム'),
		TT::MiniTereporter => _('小型テレポーター'),
		TT::BigAlarm => _('大音量アラーム'),
		TT::Tereporter => _('テレポーター'),
	}
	TRAP_CAPTIONS = TRAP_NAMES


	TRAP_LEVELS = {}
	TRAP_LEVELS[TT::Stone] = 2
	TRAP_LEVELS[TT::Needle] = 4
	TRAP_LEVELS[TT::Burner] = 6
	TRAP_LEVELS[TT::PoisonNeedle] = 7
	TRAP_LEVELS[TT::MiniBomb] = 9
	TRAP_LEVELS[TT::Alarm] = 11
	TRAP_LEVELS[TT::MiniTereporter] = 13
	
	module SelectType
		BattleCommand = 'BattleCommand'
		Trick = 'Trick'
		Charge = 'Charge'
		SharpAttack = 'SharpAttack'
	end
	

	
		

	ABILITY_NAMES = %W(str tec agl wil psy)
	ABILITY_CC_NAMES = %W(Str Tec Agl Wil Psy)
	BONUS_NAMES = %W(hitting_bonus avoid_bonus str_bonus tec_bonus agl_bonus wil_bonus psy_bonus)
	


	DIR_LIST = [DIR_N, DIR_E, DIR_S, DIR_W]
	DIR_NAMES = {DIR_N => _('北'), DIR_E => _('東'), DIR_S => _('南'), DIR_W => _('西')}
	
	# 宿屋の回復率
	INN_HEALING = {:stable => 0.3, :standard => 0.6, :large => 1.0, :royal => 1.0}

	AVOID_BONUS_ON_GUARDING = 20
	AVOID_PENALTY_ON_UNGUARDING = 5

	FRONT_GROUP_MAX = 2
	BACK_GROUP_MAX = 2
	
	GROUP_MARGIN = 24
	ENEMY_AREA_MARGIN = 16
	
	TEXT_AREA_SPACE_DEFAULT = 16
	
	EQUIPMENT_SAMPLE_DATA = [
		[s_('WeaponType|短剣'), 'NoviceSword'],
		[s_('WeaponType|長剣'), 'LongSword'],
		[s_('WeaponType|両手剣'), 'Claymore'],
		[s_('WeaponType|槍'), 'NoviceSpear'],
		[s_('WeaponType|騎兵槍'), 'Lance'],
		[s_('WeaponType|斧'), 'HandAxe'],
		[s_('WeaponType|棍棒'), 'NoviceClub'],
		[s_('WeaponType|弓'), 'NoviceBow'],
		[s_('WeaponType|杖'), 'RubyRod'],
		[s_('WeaponType|小型盾'), 'NoviceGuard'],
		[s_('WeaponType|大型盾'), 'LargeShield'],
		[s_('WeaponType|外套'), 'NoviceCloak'],
		[s_('WeaponType|軽鎧'), 'NoviceArmor'],
		[s_('WeaponType|重鎧'), 'Lamellar'],
	]

end



