# encoding: utf-8
require 'wx'
require 'wxconstructor'



module DarkHall
	module Game
		def self.show_background_input_dialog(old_background = {})
			$tmp = {}
			$tmp[:old] = old_background
			BackGroundInput::App.new.main_loop
			
			return($tmp[:result])
		end
	end
	


	module BackGroundInput
	
		class App < Wx::App
			include GetText
			def on_init
				@dialog = MainDialog.new(nil, :title => _('背景情報の入力'))
				@dialog.show
			end
		end
		
		class MainDialog < Wx::Frame
			include GetText
			def initialize(*args)
				super
				self.window_style |= Wx::STAY_ON_TOP
				centre
	
				topsz = nil
				dialog = self
				construct_children do
					widget Wx::Panel do
						topsz = vbox_sizer do
							expand
							border 8
							widget Wx::StaticText, :label => _('背景情報を入力してください。')

							hbox_sizer do
								border 4
								stretch_spacer 1
								but = widget(Wx::Button, :name => 'all_random_button', :label => _('すべてランダムに決める'))
								dialog.evt_button(but, :on_random_all_set)
							end
							
							static_hbox_sizer(_('性別')) do
								border 4
								
								old_sextype = $tmp[:old]['sextype'] || ''
								
								rb = widget Wx::RadioButton, :name => 'male', :label => _('男性')
								rb.value = true if old_sextype == 'male'
								
								rb = widget Wx::RadioButton, :name => 'female', :label => _('女性')
								rb.value = true if old_sextype == 'female'
								
								rb = widget Wx::RadioButton, :label => _('性別不明')
								rb.value = true if old_sextype == ''
								
								stretch_spacer 1

								
								but = widget Wx::Button, :label => _('ランダムに決める')
								dialog.evt_button(but, :on_random_sextype_set)
							end
			
							
							static_hbox_sizer(_('冒険の目的')) do
								border 4
								proportion 1
								text = widget Wx::TextCtrl, :name => 'purpose', :value => ($tmp[:old]['purpose'] || ''), :size => [300, 20]
								proportion 0
								but = widget Wx::Button, :label => _('ランダムに決める')
								dialog.evt_button(but, :on_random_purpose_set)
								dialog.evt_text(text, :on_text_changed)
							end
							
							static_hbox_sizer('性格') do
								border 4
								proportion 1
								text = widget Wx::TextCtrl, :name => 'personality', :value => ($tmp[:old]['personality'] || ''), :size => [300, 20]
								proportion 0
								but = widget Wx::Button, :label => _('ランダムに決める')
								dialog.evt_button(but, :on_random_personality_set)
								dialog.evt_text(text, :on_text_changed)
							end
							
							static_hbox_sizer(_('日々の楽しみ')) do
								border 4
								proportion 1
								text = widget Wx::TextCtrl, :name => 'fun', :value => ($tmp[:old]['fun'] || ''), :size => [300, 20]
								proportion 0
								but = widget Wx::Button, :label => _('ランダムに決める')
								dialog.evt_button(but, :on_random_fun_set)
								dialog.evt_text(text, :on_text_changed)
							end
	
=begin
							static_hbox_sizer('得意技') do
								border 4
								proportion 1
								widget Wx::TextCtrl, :name => 'speciality', :value => '', :size => [300, 20]
								proportion 0
								but = widget Wx::Button, :label => 'ランダムに決める'
								dialog.evt_button(but, :on_random_battle_role_set)
							end
=end

							err = widget Wx::StaticText, :name => 'error_message', :label => _('* 入力可能なのは全角24文字まで *')
							err.foreground_colour = Wx::RED
							
							hbox_sizer do
								stretch_spacer 2
								proportion 2
								but = widget Wx::Button, :label => _('決定'), :name => 'decide_button'
								but.set_default
								dialog.evt_button(but, :on_decide)
								stretch_spacer 1
								but = widget Wx::Button, :label => _('キャンセル')
								dialog.evt_button(but){ dialog.close }
								stretch_spacer 2
							end
						end
					end
				end
				
				topsz.fit(self)
				
				on_text_changed

				# マウスで選択肢を選んだ直後にダイアログを開くと、フォーカスが外れる（原因不明）
				# その対策として0.1秒後にフォーカスを再セット
				Wx::Timer.after(100){
					dialog.set_focus
					find_window_by_name('all_random_button').set_focus
				}
			end
			
			def on_random_all_set
				on_random_sextype_set
				on_random_purpose_set
				on_random_personality_set
				on_random_fun_set
			end
			
			def on_random_sextype_set
				case rand(2)
				when 0
					find_window_by_name('male').value = true
				when 1
					find_window_by_name('female').value = true
				end
			end
			
			def on_random_purpose_set
				tc = find_window_by_name('purpose')
				
				list = [
					_("迷宮を突破した英雄になり、名声を得るため"),
					_("自らを主人公とした物語を作るため"),
					_("武芸の技をきわめるため"),
					_("呪文の技をきわめるため"),
					_("迷宮の中で倒れた、兄の仇を討つため"),
					_("まだ見ぬ幻の呪文を見つけるため"),
					_("まだ見ぬ幻の秘宝を見つけるため"),
					_("まだ見ぬ幻の食材を見つけるため"),
					_("まだ見ぬ強敵に会うため"),
					_("１体でも多くの亡霊を浄化するため"),
					_("１体でも多くの敵を殺すため"),
					_("武器を思う存分振るうため"),
					_("平凡な日々が退屈で、スリルの中で生きたいため"),
					_("街より迷宮の中の方が性に合っているため"),
					_("戦いを愛しているため"),
					_("財宝を手に入れ、一生楽に暮らすため"),
					_("貧しい状況を脱出するため"),
					_("貧しい家族を助けるため"),
					_("賭け事による莫大な借金を帳消しにするため"),
					_("功績を挙げて免罪を受けるため"),
					_("死に場所を探すため"),
					_("怪物・魔物について研究するため"),
					_("迷宮にまつわる伝承の真実を確かめるため"),
					_("迷宮の最深部に何があるのかを確かめるため"),
					_("犯罪を犯し、ほかに生きる道がないため"),
					_("仕えている主からの命令を受けたため"),
					_("夢で何者かのお告げを聞いたため"),
					_("仲間を危険から守るため"),
					_("仲間の冒険をもとに、詩を作るため"),
					_("仲間の冒険をもとに、物語を書くため"),
					_("仲間の冒険や魔物をもとに、絵を描くため"),
					_("仲間にむりやり連れてこられた"),
					_("愛する者の病気を治すため"),
				]
				
				tc.value = list[rand(list.size)]
			end
			
			def on_random_personality_set
				tc = find_window_by_name('personality')
				
				list = [
					_("正義感が強く、悪の行いを見過ごせない"),
					_("楽観的で享楽主義、「人生楽しければいい」が持論"),
					_("探求心にあふれ、あらゆるものを自分で確かめたい"),
					_("竹を割ったような性格で、細かいことを気にしない"),
					_("寡黙で何を考えているかがよく分からない"),
					_("普段はぼんやりしているが、危地では力を発揮する"),
					_("真面目で気が利く。若干神経質なところもある"),
				]
				
				tc.value = list[rand(list.size)]
			end
			
			def on_random_fun_set
				tc = find_window_by_name('fun')
				
				list = [
					_("煙草"),
					_("安酒で飲み騒ぐこと"),
					_("高級酒を楽しむこと"),
					_("美味しいものを食べること"),
					_("贅沢なものを食べること"),
					_("敵を屠ること"),
					_("武器や防具の手入れ"),
					_("街の離れでの修練"),
					_("呪文の研究・実験"),
					_("呪文書を読むこと"),
					_("物語の本を読むこと"),
					_("宿の快適な部屋でだらだらと過ごすこと"),
					_("武器のコレクション"),
					_("鉱石のコレクション"),
					_("数学の研究"),
					_("古代史・伝承の研究"),
					_("現代史の研究"),
					_("建築学の研究"),
					_("賭け事"),
					_("飼い猫を愛でること"),
				]
				
				tc.value = list[rand(list.size)]
			end
			
			def on_random_speciality_set
				tc = find_window_by_name('speciality')
				
				list = [
					"武器で一刀両断",
				]
				
				tc.value = list[rand(list.size)]
			end
			
			
			
			MAX_CHAR_SIZE = 24 * 2
			
			def on_text_changed
				if validate_length(find_window_by_name('purpose')) and
				validate_length(find_window_by_name('personality'))  and
				validate_length(find_window_by_name('fun'))  then
					find_window_by_name('error_message').hide
					find_window_by_name('decide_button').enable
				else
					find_window_by_name('error_message').show
					find_window_by_name('decide_button').disable
				end

			end
			
			def validate_length(text_ctrl)
				drawn_width = Game.regular_ttf.text_size(text_ctrl.value)[0]
				
				return(drawn_width <= Game.char_width * MAX_CHAR_SIZE)
			end
			
			def on_decide
				re = $tmp[:result] = {}
				if find_window_by_name('male').value then
					re['sextype'] = 'male'
				elsif find_window_by_name('female').value then
					re['sextype'] = 'female'
				end
				
				re['purpose'] = find_window_by_name('purpose').value
				re['personality'] = find_window_by_name('personality').value
				re['fun'] = find_window_by_name('fun').value
				close
			end
			
		end
		
	end
end
