# VisualuRubyダイアログ
require 'vr/vruby'
require 'vr/vrcontrol'
require 'vr/vrdialog'

module DarkHall
	def Game.show_name_input_dialog(message, default = "")
		$tmp = {}
		$tmp[:message] = message
		$tmp[:default] = default
		return VRLocalScreen.modalform(nil, nil, NameInputDialog)

	end

	module NameInputDialog
		def construct
			self.caption = Uconv.u8tosjis(s_("Dialog|名前の入力"))
			self.move(VRLocalScreen.width/2 - 240/2, VRLocalScreen.height/2 - 96/2, 240, 96)
			self.addControl(VRStatic, 'message', Uconv.u8tosjis($tmp[:message]), 8, 8, self.w - 8, 16)
			self.addControl(VREdit, 'edit', Uconv.u8tosjis($tmp[:default]), 24, 32, 120, 20)
			self.addControl(VRButton, 'button', Uconv.u8tosjis(s_("Dialog|決定")), (@edit.x + @edit.w + 8), @edit.y, 50, @edit.h)
			
			# デフォルトボタンに設定
			self.setButtonAs(@button,VRDialogComponent::IDOK)
			
			# フォント設定
			font = SWin::LWFactory.new(SWin::Application.hInstance).newfont('MS UI Gothic', 12)
			@message.setFont(font)
			@edit.setFont(font)
			@button.setFont(font)
			
			
			# フォーカス
			@edit.focus
			self.top(0xffffffff)
		end
		
	
		
		def button_clicked
			self.close(Uconv.sjistou8(@edit.text))
		end
	end
	
end
