<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
	<html lang="ja">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
		<title>精密採点の結果</title>
		<script type="text/javascript">
			var songs = new Array();
			var results = new Array();
			<xsl:apply-templates select="document('songs.xml')/songs"/>
			<xsl:apply-templates select="document('results.xml')/results"/>
		</script>
		<script type="text/javascript" src="view.js"></script>
		<link rel="stylesheet" type="text/css" href="view.css"/>
	</head>
	<body onload="init();">
		<div id="divSelecter1st"></div>
		<div id="divSelecter2nd"></div>
		<div id="divButton"></div>
		<div id="divView"></div>
		</body>
	</html>
</xsl:template>


<xsl:template match="songs">
	<xsl:for-each select="song">
		songs[&quot;<xsl:value-of select="./@id"/>&quot;] = {
			&quot;title&quot;: &quot;<xsl:value-of select="title"/>&quot;,
			&quot;artist&quot;: &quot;<xsl:value-of select="artist"/>&quot;
		};
	</xsl:for-each>
</xsl:template>


<xsl:template match="results">
	<xsl:for-each select="result">
		results[results.length] = {
			&quot;date&quot;: &quot;<xsl:value-of select="./@date"/>&quot;,
			&quot;id&quot;: &quot;<xsl:value-of select="id"/>&quot;,
			&quot;score&quot;: &quot;<xsl:value-of select="score"/>&quot;,
			&quot;vibratoType&quot;: &quot;<xsl:value-of select="vType"/>&quot;,
			&quot;vibratoTime&quot;: &quot;<xsl:value-of select="vTime"/>&quot;,
			&quot;shakuri&quot;: &quot;<xsl:value-of select="shakuri"/>&quot;,
			&quot;interval&quot;: &quot;<xsl:value-of select="interval"/>&quot;,
			&quot;rhythm&quot;: &quot;<xsl:value-of select="rhythm"/>&quot;,
			&quot;modulation&quot;: &quot;<xsl:value-of select="modulation"/>&quot;
		};
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>