/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl.data;

import java.util.HashMap;
import java.util.Map;

public class SongId {
    public static final int ID_LENGTH = 7;
    private static Map<String, SongId> map = new HashMap<String, SongId>();
    private String value;

    private SongId(String id) {
        if (id == null) {
            throw new NullPointerException("SongId.SongId\n\tid=" + id);
        }
        if (!SongId.isValid(id)) {
            throw new IllegalArgumentException("SongId.SongId\n\tid=" + id);
        }
        this.value = id;
    }

    public static SongId getInstance(String id) {
        if (map.containsKey(id)) {
            return map.get(id);
        }
        SongId instance = new SongId(id);
        map.put(id, instance);
        return instance;
    }

    public static boolean isValid(String id) {
        if (id == null) {
            throw new NullPointerException("SongId.isValild\n\tid=" + id);
        }
        if (7 != id.length()) {
            return false;
        }
        for (int i = 0; i < 7; ++i) {
            if (!(4 == i ? '-' != id.charAt(i) : !Character.isDigit(id.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

