/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl.data;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.damstation_dl.data.DomUtility;
import jp.sourceforge.damstation_dl.data.SongData;
import jp.sourceforge.damstation_dl.data.SongId;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SongDataList {
    private Map<SongId, SongData> map = new HashMap<SongId, SongData>();

    public SongDataList() {
    }

    public SongDataList(String filePath) {
        if (filePath == null) {
            throw new NullPointerException("SongDataList.SongDataList\n\tfilePath=" + filePath);
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(filePath)), "UTF-8");
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(reader));
            Document dom = parser.getDocument();
            Element root = DomUtility.getRootElementByTagName(dom, "songs");
            NodeList songElementList = root.getElementsByTagName("song");
            for (int i = 0; i < songElementList.getLength(); ++i) {
                Element songElement = (Element)songElementList.item(i);
                SongId id = SongId.getInstance(DomUtility.getAttribute(songElement, "id"));
                if (this.hasSongData(id)) {
                    throw new IllegalStateException("SongDataList.SongDataList samed id.\n\tfilePath=" + filePath + "\n\tid=" + id);
                }
                String title = DomUtility.getSingleTextContentByTagName(songElement, "title");
                String artist = DomUtility.getSingleTextContentByTagName(songElement, "artist");
                SongData data = new SongData(title, artist);
                this.add(id, data);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("SongDataList.SongDataList\n\tfilePath=" + filePath + "\n\te=" + e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("SongDataList.SongDataList\n\tfilePath=" + filePath + "\n\te=" + e);
        }
        catch (IOException e) {
            throw new IllegalStateException("SongDataList.SongDataList\n\tfilePath=" + filePath + "\n\te=" + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean hasSongData(SongId id) {
        if (id == null) {
            throw new NullPointerException("SongDataList.hasSongData\n\tid=" + id);
        }
        return this.map.containsKey(id);
    }

    public void add(SongId id, SongData data) {
        if (id == null || data == null) {
            throw new NullPointerException("SongDataList.add\n\tid=" + id + "\n\tdata=" + data);
        }
        this.map.put(id, data);
    }

    public void writeXml(String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("SongDataList.writeXml\n\tfilePath=" + filePath);
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8")));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<songs>");
            for (Map.Entry<SongId, SongData> entry : this.map.entrySet()) {
                writer.println("\t<song id=\"" + entry.getKey().getValue() + "\">");
                writer.println("\t\t" + DomUtility.toElementString("title", DomUtility.escapeXmlEntityCharacter(entry.getValue().getTitle())));
                writer.println("\t\t" + DomUtility.toElementString("artist", DomUtility.escapeXmlEntityCharacter(entry.getValue().getArtist())));
                writer.println("\t</song>");
            }
            writer.println("</songs>");
        }
        catch (IOException e) {
            throw new IOException("SongDataList.writeXml\n\tfilePath=" + filePath + "\n\te=" + e);
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

