/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl.data;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import jp.sourceforge.damstation_dl.data.DomUtility;
import jp.sourceforge.damstation_dl.data.Proxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigData {
    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    private String cardNumber = "";
    private String password = "";
    private int connectTimeout = 5000;
    private int readTimeout = 5000;
    private Proxy proxy = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConfigData(String filePath) {
        if (filePath == null) {
            throw new NullPointerException("ConfigData.ConfigData\n\tfilePath=" + filePath);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(reader));
            Document dom = parser.getDocument();
            Element root = DomUtility.getRootElementByTagName(dom, "config");
            this.cardNumber = DomUtility.getSingleTextContentByTagName(root, "cardNumber");
            this.password = DomUtility.getSingleTextContentByTagName(root, "password");
            this.connectTimeout = Integer.parseInt(DomUtility.getSingleTextContentByTagName(root, "connectTimeout"));
            this.readTimeout = Integer.parseInt(DomUtility.getSingleTextContentByTagName(root, "readTimeout"));
            NodeList proxyList = root.getElementsByTagName("proxy");
            switch (proxyList.getLength()) {
                case 0: {
                    this.proxy = null;
                    return;
                }
                case 1: {
                    Element proxyElement = (Element)proxyList.item(0);
                    this.proxy = new Proxy(DomUtility.getSingleTextContentByTagName(proxyElement, "host"), Integer.parseInt(DomUtility.getSingleTextContentByTagName(proxyElement, "port")));
                    return;
                }
                default: {
                    throw new IllegalStateException("ConfigData.ConfigData\n\tfilePath=" + filePath + "\n\tproxyList.getLength()=" + proxyList.getLength());
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            return;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("ConfigData.ConfigData\n\tfilePath=" + filePath + "\n\te=" + e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("ConfigData.ConfigData\n\tfilePath=" + filePath + "\n\te=" + e);
        }
        catch (IOException e) {
            throw new IllegalStateException("ConfigData.ConfigData\n\tfilePath=" + filePath + "\n\te=" + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setCardNumber(String cardNumber) {
        if (cardNumber == null) {
            throw new NullPointerException("ConfigData.setCardNumber\n\tcardNumber=" + cardNumber);
        }
        this.cardNumber = cardNumber;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("ConfigData.setConnectTimeout\n\tconnectTimeout=" + connectTimeout);
        }
        this.connectTimeout = connectTimeout;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new NullPointerException("ConfigData.setPassword\n\tpassword=" + password);
        }
        this.password = password;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("ConfigData.setReadTimeout\n\treadTimeout=" + readTimeout);
        }
        this.readTimeout = readTimeout;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void writeXml(String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("ConfigData.writeXml\n\tfilePath=" + filePath);
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8")));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<config>");
            writer.println("\t" + DomUtility.toElementString("cardNumber", DomUtility.escapeXmlEntityCharacter(this.cardNumber)));
            writer.println("\t" + DomUtility.toElementString("password", DomUtility.escapeXmlEntityCharacter(this.password)));
            writer.println("\t" + DomUtility.toElementString("connectTimeout", Integer.toString(this.connectTimeout)));
            writer.println("\t" + DomUtility.toElementString("readTimeout", Integer.toString(this.readTimeout)));
            if (null != this.proxy) {
                writer.println("\t" + DomUtility.toElementString("proxy", "\n\t\t" + DomUtility.toElementString("host", DomUtility.escapeXmlEntityCharacter(this.proxy.getHost())) + "\n\t\t" + DomUtility.toElementString("port", Integer.toString(this.proxy.getPort())) + "\n\t"));
            }
            writer.println("</config>");
        }
        catch (IOException e) {
            throw new IOException("ConfigData.writeXml\n\tfilePath=" + filePath + "\n\te=" + e.toString());
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{cardNumber=");
        buffer.append(this.cardNumber);
        buffer.append(", password=");
        buffer.append(this.password);
        buffer.append(", connectTimeout=");
        buffer.append(this.connectTimeout);
        buffer.append(", readTimeout=");
        buffer.append(this.readTimeout);
        buffer.append(", proxy=");
        buffer.append(this.proxy);
        buffer.append("}");
        return buffer.toString();
    }
}

