/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jp.sourceforge.damstation_dl.DownloadThread;
import jp.sourceforge.damstation_dl.data.ConfigData;
import jp.sourceforge.damstation_dl.data.PasswordUtility;
import jp.sourceforge.damstation_dl.data.ResultData2List;
import jp.sourceforge.damstation_dl.data.ResultDataList;
import jp.sourceforge.damstation_dl.data.SongDataList;

public class MainWindow
extends JFrame {
    public static final String CONFIG_FILE_IN = "config.xml";
    public static final String CONFIG_FILE_OUT = "config.xml";
    public static final String SONG_FILE_IN = "songs.xml";
    public static final String SONG_FILE_OUT = "songs.xml";
    public static final String RESULT_FILE_IN = "results.xml";
    public static final String RESULT_FILE_OUT = "results.xml";
    public static final String RESULT2_FILE_IN = "results2.xml";
    public static final String RESULT2_FILE_OUT = "results2.xml";
    private final ConfigData configData;
    private final SongDataList songData;
    private final ResultDataList resultData;
    private final ResultData2List resultData2;
    private DownloadThread thread = null;
    private JButton jButton1;
    private JButton jButton2;
    private JTextField jCardNumberField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPasswordField jPasswordField;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea;

    public MainWindow() {
        this.initComponents();
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
        this.configData = new ConfigData("config.xml");
        this.songData = new SongDataList("songs.xml");
        this.resultData = new ResultDataList("results.xml");
        this.resultData2 = new ResultData2List("results2.xml");
        this.setFieldValue();
    }

    private void initComponents() {
        this.jCardNumberField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jPasswordField = new JPasswordField();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("DAM\u30b9\u30c6\u30fc\u30b7\u30e7\u30f3\u30c0\u30a6\u30f3\u30ed\u30fc\u30c0");
        this.setResizable(false);
        this.jLabel1.setText("\u30ab\u30fc\u30c9\u756a\u53f7");
        this.jLabel2.setText("\u30d1\u30b9\u30ef\u30fc\u30c9");
        this.jButton1.setText("\u958b\u59cb");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTextArea.setColumns(20);
        this.jTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea);
        this.jPasswordField.setEchoChar('\uff0a');
        this.jButton2.setText("\u4e2d\u6b62");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 449, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1, GroupLayout.Alignment.LEADING, -2, 133, -2).addGroup(layout.createSequentialGroup().addComponent(this.jCardNumberField, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, -2, 148, -2).addComponent(this.jPasswordField, -2, 162, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jCardNumberField, -2, -1, -2).addComponent(this.jPasswordField, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addGap(23, 23, 23).addComponent(this.jScrollPane1, -1, 204, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.thread == null || this.thread.isDone()) {
            this.getFieldValue();
            this.thread = new DownloadThread(this.jButton1, this.jTextArea, this.configData, this.songData, this.resultData, this.resultData2);
            this.thread.execute();
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.thread != null && !this.thread.isDone()) {
            this.thread.cancel(true);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MainWindow frame = new MainWindow();
                frame.init();
                frame.setVisible(true);
            }
        });
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent event) {
                if (MainWindow.this.thread != null && !MainWindow.this.thread.isDone()) {
                    return;
                }
                Object object = MainWindow.this.configData;
                synchronized (object) {
                    MainWindow.this.getFieldValue();
                    if (MainWindow.this.configData != null) {
                        try {
                            MainWindow.this.configData.writeXml("config.xml");
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                object = MainWindow.this.songData;
                synchronized (object) {
                    if (MainWindow.this.songData != null) {
                        try {
                            MainWindow.this.songData.writeXml("songs.xml");
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                object = MainWindow.this.resultData;
                synchronized (object) {
                    if (MainWindow.this.resultData != null) {
                        try {
                            MainWindow.this.resultData.writeXml("results.xml");
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                object = MainWindow.this.resultData2;
                synchronized (object) {
                    if (MainWindow.this.resultData2 != null) {
                        try {
                            MainWindow.this.resultData2.writeXml("results2.xml");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                MainWindow.this.dispose();
            }
        });
    }

    private void setFieldValue() {
        this.jCardNumberField.setText(this.configData.getCardNumber());
        this.jPasswordField.setText(PasswordUtility.decode(this.configData.getPassword()));
    }

    private void getFieldValue() {
        this.configData.setCardNumber(this.jCardNumberField.getText());
        this.configData.setPassword(PasswordUtility.encode(new String(this.jPasswordField.getPassword())));
    }
}

