<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/シューティング">
  <html>
    <body>
      <xsl:apply-templates/>
    </body>
  </html>
</xsl:template>

<xsl:template match="*">
    <p>不明なエレメント: <xsl:value-of select="name()"/> </p>
</xsl:template>

<xsl:key name="名前" match="*" use="@名前"/>

<xsl:template match="/シューティング/自機" />
<xsl:template match="/シューティング/ウィンドウ" />
<xsl:template match="/シューティング/ラベル" />
<xsl:template match="/シューティング/音楽" />
<xsl:template match="/シューティング/効果音" />
<xsl:template match="/シューティング/敵" />

<xsl:template match="画像">
  <img src="{text()}"/>
</xsl:template>

<xsl:template match="ファイル">
  <a href="{text()}">
    <xsl:value-of select="text()" />
  </a>
</xsl:template>

<xsl:template match="/シューティング/場面">
<h2><xsl:value-of select="name()"/>::<xsl:value-of select="@継承"/>::<xsl:value-of select="@名前"/></h2>

<table border="">
  <tr>
    <th>フレーム</th>
    <th>種類</th>
    <th>親</th>
    <th>名前</th>
    <th>ファイル</th>
    <th>パラメータ</th>
  </tr>
  <xsl:apply-templates/>
</table>
</xsl:template>

<xsl:template match="*" mode="場面_画像">
    <xsl:choose>
        <xsl:when test="画像">
            <img src="{画像}"/>
        </xsl:when>
        <xsl:when test="@継承">
            <xsl:apply-templates select="key('名前',@継承)" mode="場面_画像"/>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="*" mode="場面_ファイル">
    <xsl:choose>
        <xsl:when test="ファイル">
            <img src="{ファイル}"/>
        </xsl:when>
        <xsl:when test="@継承">
            <xsl:apply-templates select="key('名前',@継承)" mode="場面_ファイル"/>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="/シューティング/場面/*">
<tr>
<xsl:if test="name()='時間'">
  <xsl:attribute name="style">
    <xsl:value-of select="'background-color: #eeeeee;'"/>
  </xsl:attribute>
</xsl:if>

    <td> <xsl:value-of select="sum(preceding-sibling::時間)" /> </td>
    <td> <xsl:value-of select="local-name()"/> </td>
    <td> <xsl:value-of select="@継承"/> </td>
    <td> <xsl:value-of select="@名前"/> </td>
    <td>
        <xsl:apply-templates select="." mode="場面_画像"/>
        <xsl:apply-templates select="." mode="場面_ファイル"/>
    </td>
    <td>
        <xsl:apply-templates select="." mode="場面"/>
    </td>
</tr>
</xsl:template>


<xsl:template match="音楽" mode="音楽_種類">
    <xsl:choose>
        <xsl:when test="種類">
            <xsl:value-of select="種類"/>
        </xsl:when>
        <xsl:when test="@継承">
            <xsl:apply-templates select="key('名前',@継承)" mode="音楽_種類"/>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template match="音楽" mode="音楽_ループ">
    <xsl:choose>
        <xsl:when test="ループ">
            <xsl:value-of select="ループ"/>
        </xsl:when>
        <xsl:when test="@継承">
            <xsl:apply-templates select="key('名前',@継承)" mode="音楽_ループ"/>
        </xsl:when>
        <xsl:otherwise>無し</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="音楽" mode="音楽_時間">
    <xsl:choose>
        <xsl:when test="時間">
            <xsl:value-of select="時間"/>
        </xsl:when>
        <xsl:when test="@継承">
            <xsl:apply-templates select="key('名前',@継承)" mode="音楽_時間"/>
        </xsl:when>
        <xsl:otherwise>無し</xsl:otherwise>
    </xsl:choose>
</xsl:template>




<xsl:template match="音楽" mode="場面">
    効果(<xsl:apply-templates select="." mode="音楽_種類"/>),
    ループ(<xsl:apply-templates select="." mode="音楽_ループ"/>),
    時間(<xsl:apply-templates select="." mode="音楽_時間"/>)
</xsl:template>

</xsl:stylesheet>
