
/* This is an SDL implementation of an ICO to BMP translator

   (Information taken from "Icons in Win32",
	http://www.microsoft.com/win32dev/ui/icons.htm)
 */

#include <stdio.h>
#include <string.h>

#include <SDL/SDL.h>
#include <SDL/SDL_endian.h>
#include "seeico.h"

static void WriteBMP(Win32BMP *bmp, int index, const char *iconfile)
{
	char savefile[128];
	int i, j, k;
	Uint8 *pixels;
	Uint8 *pixels8;
	const SDL_Color palette_2[] = {
		{ 0x00, 0x00, 0x00, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0x00, 0xFF, 0xFF, 0 }
	};
	const SDL_Color palette_16[] = { /* FIXME: What should be here? */
		{ 0x00, 0x00, 0x00, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0xFF, 0xFF, 0xFF, 0 },
		{ 0x00, 0xFF, 0xFF, 0 }
	};
	SDL_Surface *surface;

	/* Convert raw data to little endian */
	bmp->biSize = SDL_SwapLE32(bmp->biSize);
	bmp->biWidth = SDL_SwapLE32(bmp->biWidth);
	bmp->biHeight = SDL_SwapLE32(bmp->biHeight);
	bmp->biPlanes = SDL_SwapLE16(bmp->biPlanes);
	bmp->biBitCount = SDL_SwapLE16(bmp->biBitCount);
	bmp->biCompression = SDL_SwapLE32(bmp->biCompression);
	bmp->biSizeImage = SDL_SwapLE32(bmp->biSizeImage);
	bmp->biXPelsPerMeter = SDL_SwapLE32(bmp->biXPelsPerMeter);
	bmp->biYPelsPerMeter = SDL_SwapLE32(bmp->biYPelsPerMeter);
	bmp->biClrUsed = SDL_SwapLE32(bmp->biClrUsed);
	bmp->biClrImportant = SDL_SwapLE32(bmp->biClrImportant);

	surface = SDL_AllocSurface(SDL_SWSURFACE,
			bmp->biWidth, bmp->biHeight/2,
			bmp->biBitCount <= 8 ? 8 : bmp->biBitCount,
			0, 0, 0, 0);
	if ( surface == NULL ) {
		fprintf(stderr, "Couldn't allocate surface\n");
		return;
	}

	pixels = (Uint8 *)bmp+bmp->biSize+(1<<bmp->biBitCount)*4;
	switch (bmp->biBitCount*bmp->biPlanes) {
	    case 1:
		surface->format->palette->ncolors = 2+1;
		memcpy(surface->format->palette->colors, palette_2,
						(sizeof palette_2));
		for ( i=0; i<bmp->biHeight/2; ++i ) {
			pixels8 = (Uint8 *)surface->pixels +
 					surface->h*surface->pitch -
 					(i+1)*surface->pitch;
			for ( j=0; j<bmp->biWidth*bmp->biBitCount/8; ++j ) {
				Uint8 ch = *pixels++;
				for ( k=0; k<8; ++k ) {
					*pixels8++ = (ch&0x80)>>7;
					ch <<= 1;
				}
			}
		}
		for ( i=0; i<bmp->biHeight/2; ++i ) {
			pixels8 = (Uint8 *)surface->pixels +
 					surface->h*surface->pitch -
 					(i+1)*surface->pitch;
			for ( j=0; j<bmp->biWidth/8; ++j ) {
				Uint8 ch = *pixels++;
				for ( k=0; k<8; ++k ) {
					if ( ch & 0x80 ) {
						*pixels8 = 2;
					}
					ch <<= 1;
					++pixels8;
				}
			}
		}
		break;
	    case 4:
		surface->format->palette->ncolors = 16+1;
		memcpy(surface->format->palette->colors, palette_16,
						(sizeof palette_16));
		for ( i=0; i<bmp->biHeight/2; ++i ) {
			pixels8 = (Uint8 *)surface->pixels +
 					surface->h*surface->pitch -
 					(i+1)*surface->pitch;
			for ( j=0; j<bmp->biWidth*bmp->biBitCount/8; ++j ) {
				Uint8 ch = *pixels++;
				for ( k=0; k<2; ++k ) {
					*pixels8++ = (ch&0xF0)>>4;
					ch <<= 4;
				}
			}
		}
		for ( i=0; i<bmp->biHeight/2; ++i ) {
			pixels8 = (Uint8 *)surface->pixels +
 					surface->h*surface->pitch -
 					(i+1)*surface->pitch;
			for ( j=0; j<bmp->biWidth/8; ++j ) {
				Uint8 ch = *pixels++;
				for ( k=0; k<8; ++k ) {
					if ( ch & 0x80 ) {
						*pixels8 = 16;
					}
					ch <<= 1;
					++pixels8;
				}
			}
		}
		break;
	    case 8:
	    case 15:
	    case 16:
	    case 24:
	    case 32:
		/* FIXME */
		fprintf(stderr, "Conversion of %d bpp images not supported\n",
						bmp->biBitCount*bmp->biPlanes);
		break;
	}
	strcpy(savefile, iconfile);
	if ( strrchr(savefile, '.') ) {
		*(strrchr(savefile, '.')) = '\0';
	}
	sprintf(&savefile[strlen(savefile)], "-%d", index);
	strcat(savefile, ".bmp");
	SDL_SaveBMP(surface, savefile);
}

static void PrintBMP(Win32BMP *bmp)
{
	int i, j, k;
	Uint8 *pixels;

	/* Convert raw data to little endian */
	bmp->biSize = SDL_SwapLE32(bmp->biSize);
	bmp->biWidth = SDL_SwapLE32(bmp->biWidth);
	bmp->biHeight = SDL_SwapLE32(bmp->biHeight);
	bmp->biPlanes = SDL_SwapLE16(bmp->biPlanes);
	bmp->biBitCount = SDL_SwapLE16(bmp->biBitCount);
	bmp->biCompression = SDL_SwapLE32(bmp->biCompression);
	bmp->biSizeImage = SDL_SwapLE32(bmp->biSizeImage);
	bmp->biXPelsPerMeter = SDL_SwapLE32(bmp->biXPelsPerMeter);
	bmp->biYPelsPerMeter = SDL_SwapLE32(bmp->biYPelsPerMeter);
	bmp->biClrUsed = SDL_SwapLE32(bmp->biClrUsed);
	bmp->biClrImportant = SDL_SwapLE32(bmp->biClrImportant);

	/* Print values */
	printf("\t\tbiSize = %d\n", bmp->biSize);
	printf("\t\tbiWidth = %d\n", bmp->biWidth);
	printf("\t\tbiHeight = %d\n", bmp->biHeight);
	printf("\t\tbiPlanes = %d\n", bmp->biPlanes);
	printf("\t\tbiBitCount = %d\n", bmp->biBitCount);
	printf("\t\tbiCompression = %d\n", bmp->biCompression);
	printf("\t\tbiSizeImage = %d\n", bmp->biSizeImage);
	printf("\t\tbiXPelsPerMeter = %d\n", bmp->biXPelsPerMeter);
	printf("\t\tbiYPelsPerMeter = %d\n", bmp->biYPelsPerMeter);
	printf("\t\tbiClrUsed = %d\n", bmp->biClrUsed);
	printf("\t\tbiClrImportant = %d\n", bmp->biClrImportant);

	pixels = (Uint8 *)bmp+bmp->biSize+(1<<bmp->biBitCount)*4;
	printf("** Data (inverted)\n");
	for ( i=0; i<bmp->biHeight/2; ++i ) {
		for ( j=0; j<bmp->biWidth*bmp->biBitCount/8; ++j )
			printf("%2.2X", *pixels++);
		printf("\n");
	}
	printf("** Palette\n");
	printf("** Mask (inverted)\n");
	for ( i=0; i<bmp->biHeight/2; ++i ) {
		for ( j=0; j<bmp->biWidth/8; ++j ) {
			int ch = *pixels++;
			for ( k=0; k<8; ++k ) {
				printf("%2.2X", ch&0x80 ? 0xFF : 0x00);
				ch <<= 1;
			}
		}
		printf("\n");
	}
	printf("Final position: %d\n", (int)pixels-(int)bmp);
}

int main(int argc, char *argv[])
{
	ICONDIRENTRY ico_entry;
	SDL_RWops *ico;
	int numicons;
	long pos, i;
	Win32BMP *bmp;

	/* Initialize SDL */
	if ( SDL_Init(0) < 0 ) {
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		exit(-1);
	}
	atexit(SDL_Quit);

	/* Check command line */
	if ( argc < 2 ) {
		fprintf(stderr, "Usage: %s file.ico\n", argv[0]);
		exit(1);
	}

	/* Open the ICO file, and read the header */
	ico = SDL_RWFromFile(argv[1], "rb");
	if ( ico == NULL ) {
		fprintf(stderr, "Couldn't read %s\n", argv[1]);
		exit(2);
	}
	SDL_ReadLE16(ico);
	switch ((i=SDL_ReadLE16(ico))) {
		case 1:
			printf("Collection of icons\n");
			break;
		case 2:
			printf("Collection of cursors\n");
			break;
		default:
			printf("Unknown file format: %d\n", i);
			exit(2);
	}
	numicons = SDL_ReadLE16(ico);
	printf("Number of images: %d\n", numicons);

	/* Read each icon */
	for ( i=0; i<numicons; ++i ) {
		SDL_RWread(ico, &ico_entry.bWidth, 1, 1);
		SDL_RWread(ico, &ico_entry.bHeight, 1, 1);
		SDL_RWread(ico, &ico_entry.bColorCount, 1, 1);
		SDL_RWread(ico, &ico_entry.bReserved, 1, 1);
		ico_entry.wPlanes = SDL_ReadLE16(ico);
		ico_entry.wBitCount = SDL_ReadLE16(ico);
		ico_entry.dwBytesInRes = SDL_ReadLE32(ico);
		ico_entry.dwImageOffset = SDL_ReadLE32(ico);
		printf("\timage %d: %dx%dx%d -- %d bytes\n", i, ico_entry.bWidth, ico_entry.bHeight, ico_entry.wBitCount ? 1<<ico_entry.wBitCount : ico_entry.bColorCount, ico_entry.dwBytesInRes);
		pos = SDL_RWtell(ico);
		SDL_RWseek(ico, ico_entry.dwImageOffset, SEEK_SET);
		bmp = (Win32BMP *)malloc(ico_entry.dwBytesInRes);
		if ( bmp != NULL ) {
			if ( ! SDL_RWread(ico, bmp, ico_entry.dwBytesInRes, 1) ) {
				fprintf(stderr,
					"WARNING: Couldn't read image\n");
			} else {
				PrintBMP(bmp);
#ifdef WRITE_BMP
				WriteBMP(bmp, i, argv[1]);
#endif
			}
			free(bmp);
		}
		SDL_RWseek(ico, pos, SEEK_SET);
	}
	SDL_RWclose(ico);
	exit(0);
}
