#include <iostream>
#include <string>
#include <algorithm>
#include <darts.h>
#include <iterator>

int main (int argc, char **argv)
{
  if (argc < 2) {
    std::cerr << "Usage: " << argv[0] << " Index" << std::endl;
    return -1;
  }
   
  Darts::DoubleArray da;
  std::string index = argv[argc-1];
   
  if (da.open(index.c_str())) {
    std::cerr << "Error: cannot open " << index << std::endl;
    return -1;     
  }
  
  Darts::DoubleArray::result_type  result [1024];
  Darts::DoubleArray::key_type     key    [1024];

  while (std::cin.getline (key, 1024)) {
    size_t num = da.commonPrefixSearch (key, result, 1024);
    if (num == 0) {
      std::cout << key << ": not found" << std::endl;
    } else {
      std::cout << key << ": found, num=" << num << " ";
      std::copy (result, result + num, 
		 std::ostream_iterator<Darts::DoubleArray::result_type>(std::cout, ","));
      std::cout << std::endl;
    }
  } 

  return 0; 
}
