/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.whereaboutsinformation;

import java.util.ArrayList;
import java.util.List;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;

/**
 * 行先板のResultData（名前と場所）です。 <br />
 */
public class WhereaboutsInformationContainer {

  private ALNumberField whereabouts_id = null;
  /** 名前 */
  private ALStringField name = null;

  private ALNumberField user_id = null;

  private ALStringField status = null;

  private ALStringField permission = null;

  private ALStringField return_date = null;

  private ALStringField reason = null;

  private ALStringField editable = null;

  /** 居場所リスト */
  private List<WhereaboutsInformationResultData> places = null;

  /**
   * @see com.aimluck.eip.common.ALData#initField()
   */
  // オブジェクトのフィールドを初期化するメソッドです。
  public void initField() {
    whereabouts_id = new ALNumberField();
    user_id = new ALNumberField();
    name = new ALStringField();
    status = new ALStringField();
    permission = new ALStringField();
    return_date = new ALStringField();
    reason = new ALStringField();
    editable = new ALStringField();
    places = new ArrayList<WhereaboutsInformationResultData>();
  }

  // 以下getとset
  public ALNumberField getWhereaboutsId() {
    return whereabouts_id;
  }

  public void setWhereaboutsId(long field) {
    whereabouts_id.setValue(field);
  }

  public ALNumberField getUserId() {
    return user_id;
  }

  public void setUserId(long field) {
    user_id.setValue(field);
  }

  public ALStringField getName() {
    return name;
  }

  public void setName(String field) {
    name.setValue(field);
  }

  public ALStringField getStatus() {
    return status;
  }

  public void setStatus(String field) {
    status.setValue(field);
  }

  public ALStringField getPermission() {
    return permission;
  }

  public void setPermission(String field) {
    permission.setValue(field);
  }

  public ALStringField getReturnDate() {
    return return_date;
  }

  public void setReturnDate(String field) {
    return_date.setValue(field);
  }

  public ALStringField getReason() {
    return reason;
  }

  public void setReason(String field) {
    reason.setValue(field);
  }

  public ALStringField getEditable() {
    return editable;
  }

  public void setEditable(String field) {
    editable.setValue(field);
  }

  public List<WhereaboutsInformationResultData> getPlaces() {
    return places;
  }

  public void setPlaces(List<WhereaboutsInformationResultData> p) {
    places = p;
  }

}
